/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import mods.eln.Eln;
import mods.eln.misc.Color;
import mods.eln.misc.Version;
import mods.eln.server.ConsoleArg;
import mods.eln.server.SaveConfig;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class ConsoleListener
extends CommandBase {
    private List<String> cmdVisibleList = new ArrayList<String>();
    private final String cmdNameStr_listCmd = "ls";
    private final String cmdNameStr_man = "man";
    private final String cmdNameStr_about = "about";
    private final String cmdNameStr_aging = "aging";
    private final String cmdNameStr_lampAging = "lampAging";
    private final String cmdNameStr_batteryAging = "batteryAging";
    private final String cmdNameStr_heatFurnaceFuel = "heatFurnaceFuel";
    private final String cmdNameStr_newWind = "newWind";
    private final String cmdNameStr_regenOre = "regenOre";
    private final String cmdNameStr_generateLangFileTemplate = "generateLangFileTemplate";
    private final String cmdNameStr_killMonstersAroundLamps = "killMonstersAroundLamps";
    private final String strOffsetL0 = "  ";
    private final String strOffsetL1 = "    ";
    private final int lineWrapMaxLength = 60;

    public ConsoleListener() {
        this.cmdVisibleList.add("ls");
        this.cmdVisibleList.add("man");
        this.cmdVisibleList.add("about");
        this.cmdVisibleList.add("aging");
        this.cmdVisibleList.add("lampAging");
        this.cmdVisibleList.add("batteryAging");
        this.cmdVisibleList.add("heatFurnaceFuel");
        this.cmdVisibleList.add("newWind");
        this.cmdVisibleList.add("regenOre");
        this.cmdVisibleList.add("generateLangFileTemplate");
        this.cmdVisibleList.add("killMonstersAroundLamps");
        Collections.sort(this.cmdVisibleList);
    }

    public String func_71517_b() {
        return "eln";
    }

    public String func_71518_a(ICommandSender icommandsender) {
        String str = Color.COLOR_DARK_CYAN + "ELN mod console." + Color.COLOR_BRIGHT_GREY + " Type \"\\eln \" + TAB";
        return str;
    }

    public List func_71516_a(ICommandSender icommandsender, String[] astring) {
        int argc = astring.length;
        switch (argc) {
            case 1: {
                if (astring[0].isEmpty()) {
                    icommandsender.func_145747_a((IChatComponent)new ChatComponentText(Color.COLOR_DARK_CYAN + "ELN >"));
                    icommandsender.func_145747_a((IChatComponent)new ChatComponentText(Color.COLOR_BRIGHT_GREY + "   \"" + "ls" + "\" to print the full command list."));
                    icommandsender.func_145747_a((IChatComponent)new ChatComponentText(Color.COLOR_BRIGHT_GREY + "   \"" + "man" + "\" + <command> for command usage (or command + TAB)."));
                    ArrayList<String> ret = new ArrayList<String>();
                    ret.add("ls");
                    return ret;
                }
                ArrayList<String> cmdl = new ArrayList<String>();
                for (String val : this.cmdVisibleList) {
                    if (!val.toLowerCase().startsWith(astring[0].toLowerCase())) continue;
                    cmdl.add(val);
                }
                if (cmdl.size() != 1) {
                    return cmdl;
                }
                if (((String)cmdl.get(0)).equals(astring[0])) break;
                return cmdl;
            }
        }
        this.commandMan(icommandsender, astring[0]);
        return null;
    }

    public void func_71515_b(ICommandSender ics, String[] astring) {
        String cmd = astring[0];
        if (cmd.isEmpty()) {
            return;
        }
        if (cmd.equalsIgnoreCase("man")) {
            if (astring.length == 1) {
                this.commandMan(ics, "man");
            } else {
                if (!this.checkArgCount(ics, astring, 1)) {
                    return;
                }
                this.commandMan(ics, astring[1]);
            }
        } else if (cmd.equalsIgnoreCase("ls")) {
            this.cprint(ics, Color.COLOR_DARK_CYAN + "ELN > " + Color.COLOR_DARK_YELLOW + "ls");
            this.cprint(ics, "  Public command list :");
            String line = "";
            Iterator<String> iter = this.cmdVisibleList.iterator();
            while (iter.hasNext()) {
                String val = iter.next();
                if (line.length() + val.length() + 2 > 60 - "  ".length()) {
                    this.cprint(ics, "  " + Color.COLOR_DARK_GREY + line);
                    line = "";
                }
                line = line + val;
                if (iter.hasNext()) {
                    line = line + ", ";
                    continue;
                }
                line = line + ".";
                this.cprint(ics, "  " + Color.COLOR_DARK_GREY + line);
            }
        } else if (cmd.equalsIgnoreCase("about")) {
            this.cprint(ics, Color.COLOR_DARK_CYAN + "ELN > " + Color.COLOR_DARK_YELLOW + "about");
            this.cprint(ics, "  Electrical Age - Codename " + "Eln".toUpperCase(Locale.ROOT));
            this.cprint(ics, "  V" + String.valueOf(Version.MAJOR) + '.' + String.valueOf(Version.MINOR) + " r" + Version.REVISION);
            String authorsStr = "";
            for (int idx = 0; idx < Eln.AUTHORS.length; ++idx) {
                authorsStr = authorsStr + Eln.AUTHORS[idx] + ' ';
            }
            this.cprint(ics, "  Authors: " + Color.COLOR_DARK_GREY + authorsStr);
            this.cprint(ics, "  Website: " + Color.COLOR_DARK_GREY + "https://electrical-age.net");
        } else if (cmd.equalsIgnoreCase("aging")) {
            this.cprint(ics, Color.COLOR_DARK_CYAN + "ELN > " + Color.COLOR_DARK_YELLOW + "aging");
            if (!this.checkArgCount(ics, astring, 1)) {
                return;
            }
            ConsoleArg<Boolean> arg0 = this.getArgBool(ics, astring[1]);
            if (!arg0.valid) {
                return;
            }
            SaveConfig.instance.batteryAging = (Boolean)arg0.value;
            SaveConfig.instance.electricalLampAging = (Boolean)arg0.value;
            SaveConfig.instance.heatFurnaceFuel = (Boolean)arg0.value;
            SaveConfig.instance.infinitePortableBattery = (Boolean)arg0.value == false;
            this.cprint(ics, "  Batteries / Furnace Fuel / Lamp aging : " + Color.COLOR_DARK_GREEN + this.boolToStr((Boolean)arg0.value));
            this.cprint(ics, "  Parameter saved in the map.");
        } else if (cmd.equalsIgnoreCase("lampAging")) {
            this.cprint(ics, Color.COLOR_DARK_CYAN + "ELN > " + Color.COLOR_DARK_YELLOW + "lampAging");
            if (!this.checkArgCount(ics, astring, 1)) {
                return;
            }
            ConsoleArg<Boolean> arg0 = this.getArgBool(ics, astring[1]);
            if (!arg0.valid) {
                return;
            }
            SaveConfig.instance.electricalLampAging = (Boolean)arg0.value;
            this.cprint(ics, "  Lamp aging : " + Color.COLOR_DARK_GREEN + this.boolToStr((Boolean)arg0.value));
            this.cprint(ics, "  Parameter saved in the map.");
        } else if (cmd.equalsIgnoreCase("batteryAging")) {
            this.cprint(ics, Color.COLOR_DARK_CYAN + "ELN > " + Color.COLOR_DARK_YELLOW + "batteryAging");
            if (!this.checkArgCount(ics, astring, 1)) {
                return;
            }
            ConsoleArg<Boolean> arg0 = this.getArgBool(ics, astring[1]);
            if (!arg0.valid) {
                return;
            }
            SaveConfig.instance.batteryAging = (Boolean)arg0.value;
            this.cprint(ics, "  Non portable batteries aging : " + Color.COLOR_DARK_GREEN + this.boolToStr((Boolean)arg0.value));
            this.cprint(ics, "  Parameter saved in the map.");
        } else if (cmd.equalsIgnoreCase("heatFurnaceFuel")) {
            this.cprint(ics, Color.COLOR_DARK_CYAN + "ELN > " + Color.COLOR_DARK_YELLOW + "heatFurnaceFuel");
            if (!this.checkArgCount(ics, astring, 1)) {
                return;
            }
            ConsoleArg<Boolean> arg0 = this.getArgBool(ics, astring[1]);
            if (!arg0.valid) {
                return;
            }
            SaveConfig.instance.heatFurnaceFuel = (Boolean)arg0.value;
            this.cprint(ics, "  Furnace fuel aging : " + Color.COLOR_DARK_GREEN + this.boolToStr((Boolean)arg0.value));
            this.cprint(ics, "  Parameter saved in the map.");
        } else if (cmd.equalsIgnoreCase("newWind")) {
            this.cprint(ics, Color.COLOR_DARK_CYAN + "ELN > " + Color.COLOR_DARK_YELLOW + "newWind");
            if (!this.checkArgCount(ics, astring, 0)) {
                return;
            }
            Eln.wind.newWindTarget();
            this.cprint(ics, "  New random wind amplitude target : " + Eln.wind.getTargetNotFiltred());
        } else if (cmd.equalsIgnoreCase("regenOre")) {
            this.cprint(ics, Color.COLOR_DARK_CYAN + "ELN > " + Color.COLOR_DARK_YELLOW + "regenOre");
            if (!this.checkArgCount(ics, astring, 1)) {
                return;
            }
            ConsoleArg<Boolean> arg0 = this.getArgBool(ics, astring[1]);
            if (!arg0.valid) {
                return;
            }
            Eln.saveConfig.reGenOre = (Boolean)arg0.value;
            this.cprint(ics, "  Regenerate ore at next map reload : " + Color.COLOR_DARK_GREEN + this.boolToStr((Boolean)arg0.value));
            this.cprint(ics, "  Parameter saved in the map and effective once.");
        } else if (cmd.equalsIgnoreCase("generateLangFileTemplate")) {
            this.cprint(ics, Color.COLOR_DARK_CYAN + "ELN > " + Color.COLOR_DARK_YELLOW + "generateLangFileTemplate");
            this.cprint(ics, "  New language system parses source code, see here how to generate language files: https://github.com/Electrical-Age/ElectricalAge");
        } else if (cmd.equalsIgnoreCase("killMonstersAroundLamps")) {
            this.cprint(ics, Color.COLOR_DARK_CYAN + "ELN > " + Color.COLOR_DARK_YELLOW + "killMonstersAroundLamps");
            if (!this.checkArgCount(ics, astring, 1)) {
                return;
            }
            ConsoleArg<Boolean> arg0 = this.getArgBool(ics, astring[1]);
            if (!arg0.valid) {
                return;
            }
            Eln.instance.killMonstersAroundLamps = (Boolean)arg0.value;
            this.cprint(ics, "  Avoid monsters spawning around lamps : " + Color.COLOR_DARK_GREEN + this.boolToStr((Boolean)arg0.value));
            this.cprint(ics, "  Warning: Command effective to this game instance only.");
        } else {
            this.cprint(ics, Color.COLOR_DARK_CYAN + "ELN > " + Color.COLOR_DARK_RED + "Error: Unknown command.");
        }
    }

    private boolean checkArgCount(ICommandSender ics, String[] args, int exceptedArgc) {
        if (args.length - 1 != exceptedArgc) {
            this.cprint(ics, Color.COLOR_DARK_CYAN + "ELN > " + Color.COLOR_DARK_YELLOW + args[0]);
            this.cprint(ics, "  " + Color.COLOR_DARK_RED + "Error: Bad argument count.");
            return false;
        }
        return true;
    }

    private ConsoleArg<Boolean> getArgBool(ICommandSender ics, String arg) {
        if ((arg = arg.toLowerCase()).isEmpty()) {
            this.cprint(ics, "  Error: Empty argument.");
            return new ConsoleArg<Object>(false, null);
        }
        if (arg.equals("0") || arg.equals("false") || arg.equals("no") || arg.equals("disabled")) {
            return new ConsoleArg<Boolean>(true, false);
        }
        if (arg.equals("1") || arg.equals("true") || arg.equals("yes") || arg.equals("enabled")) {
            return new ConsoleArg<Boolean>(true, true);
        }
        this.cprint(ics, "  Error: Unexcepted argument type.");
        return new ConsoleArg<Object>(false, null);
    }

    private String boolToStr(boolean val) {
        if (val) {
            return "Enabled";
        }
        return "Disabled";
    }

    private void commandMan(ICommandSender ics, String cmd) {
        this.cprint(ics, Color.COLOR_DARK_CYAN + "ELN >" + Color.COLOR_DARK_YELLOW + " man > " + Color.COLOR_WHITE + cmd);
        if (cmd.equalsIgnoreCase("man")) {
            this.cprint(ics, "  Returns help for a given command.");
            this.cprint(ics, "");
            this.cprint(ics, "  Parameters :");
            this.cprint(ics, "    @0:string : Command name to get documentation.");
            this.cprint(ics, "");
        } else if (cmd.equalsIgnoreCase("about")) {
            this.cprint(ics, "  Returns useful information on this mod.");
            this.cprint(ics, "");
            this.cprint(ics, "  No input parameters.");
            this.cprint(ics, "");
        } else if (cmd.equalsIgnoreCase("ls")) {
            this.cprint(ics, "  Lists all ELN publicly available commands.");
            this.cprint(ics, "");
            this.cprint(ics, "  No input parameters.");
            this.cprint(ics, "");
        } else if (cmd.equalsIgnoreCase("about")) {
            this.cprint(ics, "  Gives some information about ElectricalAge mod.");
            this.cprint(ics, "");
            this.cprint(ics, "  No input parameters.");
            this.cprint(ics, "");
        } else if (cmd.equalsIgnoreCase("aging")) {
            this.cprint(ics, "  Enables/disables aging on :");
            this.cprint(ics, "  - Portable and standards batteries,");
            this.cprint(ics, "  - Lamps,");
            this.cprint(ics, "  - Fuel into electrical furnaces.");
            this.cprint(ics, "  Acts as a combination of the following commands :");
            this.cprint(ics, "  - batteryAging, lampAging, heatFurnaceFuel");
            this.cprint(ics, "  Changes stored into the map.");
            this.cprint(ics, "");
            this.cprint(ics, "  Parameters :");
            this.cprint(ics, "    @0:bool : Aging state (enabled/disabled).");
            this.cprint(ics, "");
        } else if (cmd.equalsIgnoreCase("lampAging")) {
            this.cprint(ics, "  Enables/disables aging on lamps.");
            this.cprint(ics, "  Changes stored into the map.");
            this.cprint(ics, "");
            this.cprint(ics, "  Parameters :");
            this.cprint(ics, "    @0:bool : Aging state (enabled/disabled).");
            this.cprint(ics, "");
        } else if (cmd.equalsIgnoreCase("batteryAging")) {
            this.cprint(ics, "  Enables/disables aging on standard batteries.");
            this.cprint(ics, "  Changes stored into the map.");
            this.cprint(ics, "");
            this.cprint(ics, "  Parameters :");
            this.cprint(ics, "    @0:bool : Aging state (enabled/disabled).");
            this.cprint(ics, "");
        } else if (cmd.equalsIgnoreCase("heatFurnaceFuel")) {
            this.cprint(ics, "  Enables/disables aging on fuel into electrical furnaces.");
            this.cprint(ics, "  Changes stored into the map.");
            this.cprint(ics, "");
            this.cprint(ics, "  Parameters :");
            this.cprint(ics, "    @0:bool : Aging state (enabled/disabled).");
            this.cprint(ics, "");
        } else if (cmd.equalsIgnoreCase("newWind")) {
            this.cprint(ics, "  Changes progressively the wind to another target amplitude.");
            this.cprint(ics, "  Changes stored into the map.");
            this.cprint(ics, "");
            this.cprint(ics, "  No input parameters.");
            this.cprint(ics, "");
        } else if (cmd.equalsIgnoreCase("regenOre")) {
            this.cprint(ics, "  When set, regenerates ELN ores at the next map reload.");
            this.cprint(ics, "  Changes stored into the map and effective once when set.");
            this.cprint(ics, "");
            this.cprint(ics, "  Parameters :");
            this.cprint(ics, "    @0:bool : Regenerate flag (enabled/disabled).");
            this.cprint(ics, "");
        } else if (cmd.equalsIgnoreCase("generateLangFileTemplate")) {
            this.cprint(ics, "  Generate a new language file or complete an existing one");
            this.cprint(ics, "  with missing fields.");
            this.cprint(ics, "");
            this.cprint(ics, "  Parameters :");
            this.cprint(ics, "    @0:string : full file path.");
            this.cprint(ics, "");
        } else if (cmd.equalsIgnoreCase("killMonstersAroundLamps")) {
            this.cprint(ics, "  When set, monsters don't spawn around the lamps (default).");
            this.cprint(ics, "  When clear, leaving lights on in dark zones is recommended...");
            this.cprint(ics, "  Effective only during this game instance.");
            this.cprint(ics, "  (See \"Eln.cfg\" for permanent effect.)");
            this.cprint(ics, "");
            this.cprint(ics, "  Parameters :");
            this.cprint(ics, "    @0:bool : Enable/disable.");
            this.cprint(ics, "");
        } else {
            this.cprint(ics, Color.COLOR_DARK_RED + "  " + "Error : Unknown/Undocumented command.");
        }
    }

    private void cprint(ICommandSender ics, String text) {
        ics.func_145747_a((IChatComponent)new ChatComponentText(Color.COLOR_BRIGHT_GREY + text));
    }
}

