/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.server;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.HashSet;
import java.util.LinkedList;
import mods.eln.Eln;
import mods.eln.misc.Utils;
import mods.eln.ore.OreDescriptor;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;

public class OreRegenerate {
    LinkedList<ChunkRef> jobs = new LinkedList();
    HashSet<ChunkRef> alreadyLoadedChunks = new HashSet();

    public OreRegenerate() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void clear() {
        this.jobs.clear();
        this.alreadyLoadedChunks.clear();
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        for (int idx = 0; idx < 1; ++idx) {
            if (this.jobs.isEmpty()) continue;
            ChunkRef j = this.jobs.pollLast();
            if (!Eln.saveConfig.reGenOre && !Eln.instance.forceOreRegen) {
                return;
            }
            WorldServer server = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(j.worldId);
            Chunk chunk = server.func_72964_e(j.x, j.z);
            for (int y = 0; y < 60; y += 2) {
                for (int z = y & 1; z < 16; z += 2) {
                    for (int x = y & 1; x < 16; x += 2) {
                        if (chunk.func_150810_a(x, y, z) != Eln.oreBlock) continue;
                        return;
                    }
                }
            }
            Utils.println("Regenerated! " + this.jobs.size());
            for (OreDescriptor d : Eln.oreItem.descriptors) {
                d.generate(server.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, (World)server, null, null);
            }
        }
    }

    @SubscribeEvent
    public void chunkLoad(ChunkEvent.Load e) {
        block5: {
            block4: {
                if (e.world.field_72995_K) break block4;
                if (Eln.saveConfig == null) break block5;
                if (Eln.saveConfig.reGenOre) break block5;
            }
            return;
        }
        Chunk c = e.getChunk();
        ChunkRef ref = new ChunkRef(c.field_76635_g, c.field_76647_h, c.field_76637_e.field_73011_w.field_76574_g);
        if (this.alreadyLoadedChunks.contains(ref)) {
            Utils.println("Already regenerated!");
            return;
        }
        this.alreadyLoadedChunks.add(ref);
        this.jobs.addFirst(ref);
    }

    static class ChunkRef {
        public int x;
        public int z;
        public int worldId;

        public ChunkRef(int x, int z, int worldId) {
            this.x = x;
            this.z = z;
            this.worldId = worldId;
        }

        public int hashCode() {
            return this.x * this.z + (this.worldId << 20);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ChunkRef)) {
                return false;
            }
            ChunkRef other = (ChunkRef)o;
            return other.x == this.x && other.z == this.z && other.worldId == this.worldId;
        }
    }
}

