/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.server;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.Hashtable;
import java.util.Map;
import mods.eln.misc.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class PlayerManager {
    private Map<EntityPlayerMP, PlayerMetadata> metadataHash = new Hashtable<EntityPlayerMP, PlayerMetadata>();

    public PlayerManager() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void clear() {
        this.metadataHash.clear();
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        for (Map.Entry<EntityPlayerMP, PlayerMetadata> entry : this.metadataHash.entrySet()) {
            PlayerMetadata p = entry.getValue();
            p.interactRise = p.interactRiseBuffer;
            p.interactRiseBuffer = false;
            if (!p.needDelete()) continue;
            this.metadataHash.remove(entry.getKey());
        }
    }

    public PlayerMetadata get(EntityPlayerMP player) {
        PlayerMetadata metadata = this.metadataHash.get(player);
        if (metadata != null) {
            return metadata;
        }
        this.metadataHash.put(player, new PlayerMetadata((EntityPlayer)player));
        return this.metadataHash.get(player);
    }

    public PlayerMetadata get(EntityPlayer player) {
        return this.get((EntityPlayerMP)player);
    }

    public class PlayerMetadata {
        private int timeout;
        public boolean interactEnable = false;
        public boolean interactRise = false;
        public boolean interactRiseBuffer = false;
        EntityPlayer player;

        public PlayerMetadata(EntityPlayer p) {
            this.timeoutReset();
            this.player = p;
        }

        public boolean needDelete() {
            return this.timeout == 0;
        }

        public void timeoutReset() {
            this.timeout = 2400;
        }

        public void timeoutDec() {
            --this.timeout;
            if (this.timeout < 0) {
                this.timeout = 0;
            }
        }

        public void setInteractEnable(boolean interactEnable) {
            if (!this.interactEnable && interactEnable) {
                this.interactRiseBuffer = true;
                Utils.println("interactRiseBuffer");
            }
            this.interactEnable = interactEnable;
            this.timeoutReset();
            Utils.println("interactEnable : " + interactEnable);
        }

        public boolean getInteractEnable() {
            this.timeoutReset();
            return this.interactEnable;
        }
    }
}

