/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.server;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedList;
import mods.eln.Eln;
import mods.eln.misc.Coordonate;
import mods.eln.misc.Utils;
import mods.eln.node.NodeManager;
import mods.eln.server.ElnWorldStorage;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.world.WorldEvent;

public class ServerEventListener {
    LinkedList<EntityLightningBolt> lightningListNext = new LinkedList();
    LinkedList<EntityLightningBolt> lightningList = new LinkedList();
    public HashSet<Integer> loadedWorlds = new HashSet();

    public ServerEventListener() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.lightningList = this.lightningListNext;
        this.lightningListNext = new LinkedList();
    }

    @SubscribeEvent
    public void onNewEntity(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityLightningBolt) {
            this.lightningListNext.add((EntityLightningBolt)event.entity);
        }
    }

    public void clear() {
        this.lightningList.clear();
    }

    public double getLightningClosestTo(Coordonate c) {
        double best = 1.0E7;
        for (EntityLightningBolt l : this.lightningList) {
            double d;
            if (c.world() != l.field_70170_p || !((d = l.func_70011_f((double)c.x, (double)c.y, (double)c.z)) < best)) continue;
            best = d;
        }
        return best;
    }

    public String getEaWorldSaveName(World w) {
        return Utils.getMapFolder() + "data/electricalAgeWorld" + w.field_73011_w.field_76574_g + ".dat";
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        if (e.world.field_72995_K) {
            return;
        }
        this.loadedWorlds.add(e.world.field_73011_w.field_76574_g);
        try {
            FileInputStream fileStream = new FileInputStream(this.getEaWorldSaveName(e.world));
            NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)fileStream);
            ServerEventListener.readFromEaWorldNBT(nbt);
            fileStream.close();
        }
        catch (Exception ex) {
            try {
                FileInputStream fileStream = new FileInputStream(this.getEaWorldSaveName(e.world) + "back");
                NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)fileStream);
                ServerEventListener.readFromEaWorldNBT(nbt);
                fileStream.close();
            }
            catch (Exception ex2) {
                ElnWorldStorage elnWorldStorage = ElnWorldStorage.forWorld(e.world);
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload e) {
        if (e.world.field_72995_K) {
            return;
        }
        this.loadedWorlds.remove(e.world.field_73011_w.field_76574_g);
        try {
            NodeManager.instance.unload(e.world.field_73011_w.field_76574_g);
            Eln.ghostManager.unload(e.world.field_73011_w.field_76574_g);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save e) {
        if (e.world.field_72995_K) {
            return;
        }
        if (!this.loadedWorlds.contains(e.world.field_73011_w.field_76574_g)) {
            return;
        }
        try {
            NBTTagCompound nbt = new NBTTagCompound();
            ServerEventListener.writeToEaWorldNBT(nbt, e.world.field_73011_w.field_76574_g);
            FileOutputStream fileStream = new FileOutputStream(this.getEaWorldSaveName(e.world));
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)fileStream);
            fileStream.flush();
            fileStream.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        int idx = 0;
        ++idx;
    }

    public static void readFromEaWorldNBT(NBTTagCompound nbt) {
        try {
            NodeManager.instance.loadFromNbt(nbt.func_74775_l("nodes"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Eln.ghostManager.loadFromNBT(nbt.func_74775_l("ghost"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeToEaWorldNBT(NBTTagCompound nbt, int dim) {
        try {
            NodeManager.instance.saveToNbt(Utils.newNbtTagCompund(nbt, "nodes"), dim);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Eln.ghostManager.saveToNBT(Utils.newNbtTagCompund(nbt, "ghost"), dim);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

