/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.signalinductor;

import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.signalinductor.SignalInductorDescriptor;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Inductor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import net.minecraft.entity.player.EntityPlayer;

public class SignalInductorElement
extends SixNodeElement {
    public SignalInductorDescriptor descriptor;
    public NbtElectricalLoad postiveLoad = new NbtElectricalLoad("postiveLoad");
    public NbtElectricalLoad negativeLoad = new NbtElectricalLoad("negativeLoad");
    public Inductor inductor = new Inductor("inductor", this.postiveLoad, this.negativeLoad);

    public SignalInductorElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.electricalLoadList.add(this.postiveLoad);
        this.electricalLoadList.add(this.negativeLoad);
        this.electricalComponentList.add(this.inductor);
        this.postiveLoad.setAsMustBeFarFromInterSystem();
        this.descriptor = (SignalInductorDescriptor)descriptor;
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu) {
        if (this.front == lrdu) {
            return this.postiveLoad;
        }
        if (this.front.inverse() == lrdu) {
            return this.negativeLoad;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.front == lrdu) {
            return this.descriptor.cable.getNodeMask();
        }
        if (this.front.inverse() == lrdu) {
            return this.descriptor.cable.getNodeMask();
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return Utils.plotAmpere("I", this.inductor.getCurrent());
    }

    @Override
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void initialize() {
        this.descriptor.applyTo(this.negativeLoad);
        this.descriptor.applyTo(this.postiveLoad);
        this.descriptor.applyTo(this.inductor);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        return super.onBlockActivatedRotate(entityPlayer);
    }
}

