/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim;

import mods.eln.misc.FunctionTable;
import mods.eln.sim.IProcess;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.mna.state.VoltageState;

public class BatteryProcess
implements IProcess {
    VoltageState positiveLoad;
    VoltageState negativeLoad;
    public FunctionTable voltageFunction;
    public double Q = 0.0;
    public double QNominal = 0.0;
    public double uNominal = 0.0;
    public double life = 1.0;
    public VoltageSource voltageSource;
    public boolean isRechargeable = true;
    public double IMax = 20.0;

    public BatteryProcess(VoltageState positiveLoad, VoltageState negativeLoad, FunctionTable voltageFunction, double IMax, VoltageSource voltageSource) {
        this.positiveLoad = positiveLoad;
        this.negativeLoad = negativeLoad;
        this.voltageFunction = voltageFunction;
        this.IMax = IMax;
        this.voltageSource = voltageSource;
    }

    @Override
    public void process(double time) {
        this.Q -= this.voltageSource.getCurrent() * time / this.QNominal;
        double voltage = this.computeVoltage();
        this.voltageSource.setU(voltage);
    }

    double computeVoltage() {
        double voltage = this.voltageFunction.getValue(this.Q / this.life);
        return Math.max(0.0, voltage * this.uNominal);
    }

    public double getQRatio() {
        return this.Q;
    }

    public void changeLife(double newLife) {
        if (newLife < this.life) {
            this.Q *= newLife / this.life;
        }
        this.life = newLife;
    }

    public double getCharge() {
        return this.Q / this.life;
    }

    public void setCharge(double charge) {
        this.Q = this.life * charge;
    }

    public double getEnergy() {
        int stepNbr = 50;
        double chargeStep = this.getCharge() / (double)stepNbr;
        double chargeIntegrator = 0.0;
        double energy = 0.0;
        double QperStep = this.QNominal * this.life * chargeStep;
        for (int step = 0; step < stepNbr; ++step) {
            double voltage = this.voltageFunction.getValue(chargeIntegrator) * this.uNominal;
            energy += voltage * QperStep;
            chargeIntegrator += chargeStep;
        }
        return energy;
    }

    public double getEnergyMax() {
        int stepNbr = 50;
        double chargeStep = 1.0 / (double)stepNbr;
        double chargeIntegrator = 0.0;
        double energy = 0.0;
        double QperStep = this.QNominal * this.life * 1.0 / (double)stepNbr;
        for (int step = 0; step < stepNbr; ++step) {
            double voltage = this.voltageFunction.getValue(chargeIntegrator) * this.uNominal;
            energy += voltage * QperStep;
            chargeIntegrator += chargeStep;
        }
        return energy;
    }

    public double getU() {
        return this.computeVoltage();
    }

    public double getDischargeCurrent() {
        return this.voltageSource.getI();
    }
}

