/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim;

import mods.eln.server.SaveConfig;
import mods.eln.sim.BatteryProcess;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;

public abstract class BatterySlowProcess
implements IProcess {
    BatteryProcess batteryProcess;
    ThermalLoad thermalLoad;
    public double lifeNominalCurrent;
    public double lifeNominalLost;

    public BatterySlowProcess(BatteryProcess batteryProcess, ThermalLoad thermalLoad) {
        this.batteryProcess = batteryProcess;
        this.thermalLoad = thermalLoad;
    }

    @Override
    public void process(double time) {
        double U = this.batteryProcess.getU();
        if (U < -0.1 * this.batteryProcess.uNominal) {
            this.destroy();
            return;
        }
        if (U > this.getUMax()) {
            this.destroy();
            return;
        }
        if (SaveConfig.instance.batteryAging) {
            double newLife = this.batteryProcess.life;
            double normalisedCurrent = Math.abs(this.batteryProcess.getDischargeCurrent()) / this.lifeNominalCurrent;
            if ((newLife -= normalisedCurrent * normalisedCurrent * this.lifeNominalLost * time) < 0.1) {
                newLife = 0.1;
            }
            this.batteryProcess.changeLife(newLife);
        }
    }

    public double getUMax() {
        return 1.3 * this.batteryProcess.uNominal;
    }

    public abstract void destroy();
}

