/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim;

import mods.eln.sim.ElectricalConnection;
import mods.eln.sim.mna.component.Bipole;
import mods.eln.sim.mna.component.Component;
import mods.eln.sim.mna.component.Line;
import mods.eln.sim.mna.state.State;
import mods.eln.sim.mna.state.VoltageStateLineReady;

public class ElectricalLoad
extends VoltageStateLineReady {
    public static final State groundLoad = null;
    private double Rs = 1.0E9;

    public void setRs(double Rs2) {
        if (this.Rs != Rs2) {
            this.Rs = Rs2;
            for (Component c : this.getConnectedComponents()) {
                if (!(c instanceof ElectricalConnection)) continue;
                ((ElectricalConnection)c).notifyRsChange();
            }
        }
    }

    public double getRs() {
        return this.Rs;
    }

    public void highImpedance() {
        this.setRs(1.0E9);
    }

    public double getI() {
        double i = 0.0;
        for (Component c : this.getConnectedComponents()) {
            if (!(c instanceof Bipole) || c instanceof Line) continue;
            i += Math.abs(((Bipole)c).getCurrent());
        }
        return i * 0.5;
    }

    public double getCurrent() {
        return this.getI();
    }
}

