/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim;

import mods.eln.misc.Recipe;
import mods.eln.misc.RecipesList;
import mods.eln.misc.Utils;
import mods.eln.sim.IProcess;
import mods.eln.sim.mna.component.Resistor;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class ElectricalStackMachineProcess
implements IProcess {
    ElectricalStackMachineProcessObserver observer;
    public IInventory inventory;
    int inputSlotId;
    int OutputSlotId;
    int outputSlotNbr;
    Resistor electricalResistor;
    double resistorValue;
    RecipesList recipesList;
    int[] outSlotIdList;
    double efficiency = 1.0;
    double speedUp = 1.0;
    ItemStack itemStackInOld = null;
    boolean smeltInProcess = false;
    double energyNeeded = 0.0;
    double energyCounter = 0.0;

    public void setObserver(ElectricalStackMachineProcessObserver observer) {
        this.observer = observer;
    }

    public ElectricalStackMachineProcess(IInventory inventory, int inputSlotId, int OutputSlotId, int outputSlotNbr, Resistor electricalResistor, double resistorValue, RecipesList recipesList) {
        this.inventory = inventory;
        this.inputSlotId = inputSlotId;
        this.OutputSlotId = OutputSlotId;
        this.outputSlotNbr = outputSlotNbr;
        this.electricalResistor = electricalResistor;
        this.resistorValue = resistorValue;
        this.recipesList = recipesList;
        this.outSlotIdList = new int[outputSlotNbr];
        for (int idx = 0; idx < outputSlotNbr; ++idx) {
            this.outSlotIdList[idx] = idx + OutputSlotId;
        }
    }

    public void setEfficiency(double efficiency) {
        this.efficiency = efficiency;
    }

    public void setSpeedUp(double speedUp) {
        this.speedUp = speedUp;
        this.setResistorValue(this.resistorValue);
    }

    @Override
    public void process(double time) {
        boolean itemTypeChanged;
        ItemStack itemStackIn = this.inventory.func_70301_a(this.inputSlotId);
        boolean bl = itemTypeChanged = itemStackIn == null && this.itemStackInOld != null || itemStackIn != null && this.itemStackInOld == null || itemStackIn != null && this.itemStackInOld != null && itemStackIn.func_77973_b() != this.itemStackInOld.func_77973_b();
        if (itemTypeChanged || !this.smeltCan() || !this.smeltInProcess) {
            this.smeltInit();
            this.itemStackInOld = itemStackIn;
        }
        if (this.smeltInProcess) {
            this.energyCounter += this.getPower() * time;
            if (this.energyCounter > this.energyNeeded) {
                this.energyCounter -= this.energyNeeded;
                this.smeltItem();
                this.smeltInit();
            }
        }
    }

    public double getPower() {
        return this.electricalResistor.getP() * this.efficiency;
    }

    public void smeltInit() {
        this.smeltInProcess = this.smeltCan();
        if (!this.smeltInProcess) {
            this.smeltInProcess = false;
            this.energyNeeded = 1.0;
            this.energyCounter = 0.0;
            this.electricalResistor.highImpedance();
        } else {
            this.smeltInProcess = true;
            this.energyNeeded = this.recipesList.getRecipe((ItemStack)this.inventory.func_70301_a((int)this.inputSlotId)).energy;
            this.energyCounter = 0.0;
            this.electricalResistor.setR(this.resistorValue / this.speedUp);
        }
    }

    public void setResistorValue(double value) {
        this.resistorValue = value;
        if (this.smeltInProcess) {
            this.electricalResistor.setR(this.resistorValue / this.speedUp);
        }
    }

    public boolean smeltCan() {
        if (this.inventory.func_70301_a(this.inputSlotId) == null) {
            return false;
        }
        ItemStack[] output = this.getSmeltResult();
        if (output == null) {
            return false;
        }
        return Utils.canPutStackInInventory(this.getSmeltResult(), this.inventory, this.outSlotIdList);
    }

    public ItemStack[] getSmeltResult() {
        Recipe recipe = this.recipesList.getRecipe(this.inventory.func_70301_a(this.inputSlotId));
        if (recipe == null) {
            return null;
        }
        return recipe.output;
    }

    public void smeltItem() {
        if (this.smeltCan()) {
            Recipe recipe = this.recipesList.getRecipe(this.inventory.func_70301_a(this.inputSlotId));
            Utils.tryPutStackInInventory(recipe.getOutputCopy(), this.inventory, this.outSlotIdList);
            this.inventory.func_70298_a(this.inputSlotId, recipe.input.field_77994_a);
            if (this.observer != null) {
                this.observer.done(this);
            }
        }
    }

    public double processState() {
        if (!this.smeltInProcess) {
            return 0.0;
        }
        double state = this.energyCounter / this.energyNeeded;
        if (state > 1.0) {
            state = 1.0;
        }
        return state;
    }

    public double processStatePerSecond() {
        if (!this.smeltInProcess) {
            return 0.0;
        }
        double power = this.getPower() + 0.1;
        double ret = power / this.energyNeeded;
        return ret;
    }

    public static interface ElectricalStackMachineProcessObserver {
        public void done(ElectricalStackMachineProcess var1);
    }
}

