/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim;

import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;

public class FurnaceProcess
implements IProcess {
    public ThermalLoad load;
    public double combustibleEnergy = 0.0;
    public double nominalCombustibleEnergy = 1.0;
    public double nominalPower = 1.0;
    private double gain = 1.0;
    private double gainMin = 0.0;

    public FurnaceProcess(ThermalLoad load) {
        this.load = load;
    }

    @Override
    public void process(double time) {
        double energyConsumed = this.getP() * time;
        this.combustibleEnergy -= energyConsumed;
        this.load.PcTemp += energyConsumed / time;
    }

    public void setGain(double gain) {
        if (gain < this.gainMin) {
            gain = this.gainMin;
        }
        if (gain > 1.0) {
            gain = 1.0;
        }
        this.gain = gain;
    }

    public void setGainMin(double gainMin) {
        this.gainMin = gainMin;
        this.setGain(this.getGain());
    }

    public double getGain() {
        return this.gain;
    }

    public double getP() {
        return this.combustibleEnergy / this.nominalCombustibleEnergy * this.nominalPower * this.gain;
    }
}

