/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim;

import mods.eln.item.regulator.IRegulatorDescriptor;
import mods.eln.misc.INBTTReady;
import mods.eln.sim.IProcess;
import net.minecraft.nbt.NBTTagCompound;

public abstract class RegulatorProcess
implements IProcess,
INBTTReady {
    IRegulatorDescriptor.RegulatorType type = IRegulatorDescriptor.RegulatorType.None;
    double target;
    double OnOffHysteresisDiv2;
    double P;
    double I;
    double D;
    double hitLast = 0.0;
    double errorIntegrated = 0.0;
    boolean boot = true;
    String name;

    public void setManuel() {
        this.type = IRegulatorDescriptor.RegulatorType.Manual;
    }

    public void setNone() {
        this.type = IRegulatorDescriptor.RegulatorType.None;
    }

    public void setOnOff(double OnOffHysteresisFactor, double workingPoint) {
        this.type = IRegulatorDescriptor.RegulatorType.OnOff;
        this.OnOffHysteresisDiv2 = OnOffHysteresisFactor * workingPoint / 2.0;
        this.boot = false;
        this.setCmd(0.0);
    }

    public void setAnalog(double P, double I, double D, double workingPoint) {
        if (!(this.boot || this.P == (P /= workingPoint) && this.I == (I /= workingPoint) && this.D == (D /= workingPoint) && this.type == IRegulatorDescriptor.RegulatorType.Analog)) {
            this.errorIntegrated = 0.0;
            this.hitLast = this.getHit();
        }
        this.P = P;
        this.I = I;
        this.D = D;
        this.type = IRegulatorDescriptor.RegulatorType.Analog;
        this.boot = false;
    }

    public void setTarget(double target) {
        this.target = target;
    }

    public double getTarget() {
        return this.target;
    }

    protected abstract double getHit();

    protected abstract void setCmd(double var1);

    public RegulatorProcess(String name) {
        this.name = name;
    }

    @Override
    public void process(double time) {
        double hit = this.getHit();
        switch (this.type) {
            case Manual: {
                break;
            }
            case None: {
                this.setCmd(1.0);
                break;
            }
            case Analog: {
                double error = this.target - hit;
                double fP = error * this.P;
                double cmd = fP - (hit - this.hitLast) * this.D * time;
                this.errorIntegrated += error * time * this.I;
                if (this.errorIntegrated > 1.0 - fP) {
                    this.errorIntegrated = 1.0 - fP;
                    if (this.errorIntegrated < 0.0) {
                        this.errorIntegrated = 0.0;
                    }
                } else if (this.errorIntegrated < -1.0 + fP) {
                    this.errorIntegrated = -1.0 + fP;
                    if (this.errorIntegrated > 0.0) {
                        this.errorIntegrated = 0.0;
                    }
                }
                if ((cmd += this.errorIntegrated) > 1.0) {
                    this.setCmd(1.0);
                } else if (cmd < -1.0) {
                    this.setCmd(-1.0);
                } else {
                    this.setCmd(cmd);
                }
                this.hitLast = hit;
                break;
            }
            case OnOff: {
                if (hit > this.target + this.OnOffHysteresisDiv2) {
                    this.setCmd(0.0);
                }
                if (!(hit < this.target - this.OnOffHysteresisDiv2)) break;
                this.setCmd(1.0);
                break;
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String str) {
        this.errorIntegrated = nbt.func_74769_h(str + this.name + "errorIntegrated");
        if (Double.isNaN(this.errorIntegrated)) {
            this.errorIntegrated = 0.0;
        }
        this.setTarget(nbt.func_74769_h(str + this.name + "target"));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String str) {
        nbt.func_74780_a(str + this.name + "errorIntegrated", this.errorIntegrated);
        nbt.func_74780_a(str + this.name + "target", this.target);
    }
}

