/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim;

import mods.eln.sim.RegulatorProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;

public class RegulatorThermalLoadToElectricalResistor
extends RegulatorProcess {
    ThermalLoad thermalLoad;
    Resistor electricalResistor;
    double Rmin;

    public void setRmin(double Rmin) {
        this.Rmin = Rmin;
    }

    public RegulatorThermalLoadToElectricalResistor(String name, ThermalLoad thermalLoad, Resistor electricalResistor) {
        super(name);
        this.thermalLoad = thermalLoad;
        this.electricalResistor = electricalResistor;
    }

    @Override
    protected double getHit() {
        return this.thermalLoad.Tc;
    }

    @Override
    protected void setCmd(double cmd) {
        if (cmd <= 0.001) {
            this.electricalResistor.highImpedance();
        } else if (cmd >= 1.0) {
            this.electricalResistor.setR(this.Rmin);
        } else {
            this.electricalResistor.setR(this.Rmin / cmd);
        }
    }
}

