/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim;

import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sixnode.resistor.ResistorDescriptor;
import mods.eln.sixnode.resistor.ResistorElement;

public class ResistorProcess
implements IProcess {
    ResistorElement element;
    ResistorDescriptor descriptor;
    Resistor r;
    ThermalLoad thermal;
    private double lastR = -1.0;

    public ResistorProcess(ResistorElement element, Resistor r, ThermalLoad thermal, ResistorDescriptor descriptor) {
        this.element = element;
        this.descriptor = descriptor;
        this.r = r;
        this.thermal = thermal;
    }

    @Override
    public void process(double time) {
        double newR = Math.max(1.0E-9, this.element.nominalRs * (1.0 + this.descriptor.tempCoef * this.thermal.Tc));
        if (this.element.control != null) {
            newR *= (this.element.control.getNormalized() + 0.01) / 1.01;
        }
        if (newR > this.lastR * 1.01 || newR < this.lastR * 0.99) {
            this.r.setR(newR);
            this.lastR = newR;
            this.element.needPublish();
        }
    }
}

