/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim;

public class ThermalLoad {
    public double Tc;
    public double Rp;
    public double Rs;
    public double C;
    public double PcTemp;
    public double Pc;
    public double Prs;
    public double Psp;
    public double PrsTemp = 0.0;
    public double PspTemp = 0.0;
    boolean isSlow;
    public static final ThermalLoad externalLoad = new ThermalLoad(0.0, 0.0, 0.0, 0.0);

    public ThermalLoad() {
        this.setHighImpedance();
        this.Tc = 0.0;
        this.PcTemp = 0.0;
        this.Pc = 0.0;
        this.Prs = 0.0;
        this.Psp = 0.0;
    }

    public ThermalLoad(double Tc, double Rp, double Rs2, double C) {
        this.Tc = Tc;
        this.Rp = Rp;
        this.Rs = Rs2;
        this.C = C;
        this.PcTemp = 0.0;
    }

    public void setRsByTao(double tao) {
        this.Rs = tao / this.C;
    }

    public void setHighImpedance() {
        this.Rs = 1.0E9;
        this.C = 1.0;
        this.Rp = 1.0E9;
    }

    public void setRp(double Rp) {
        this.Rp = Rp;
    }

    public double getPower() {
        return (this.Prs + Math.abs(this.Pc) + this.Tc / this.Rp + this.Psp) / 2.0;
    }

    public void set(double Rs2, double Rp, double C) {
        this.Rp = Rp;
        this.Rs = Rs2;
        this.C = C;
    }

    public static void moveEnergy(double energy, double time, ThermalLoad from, ThermalLoad to) {
        double I = energy / time;
        double absI = Math.abs(I);
        from.PcTemp -= I;
        to.PcTemp += I;
        from.PspTemp += absI;
        to.PspTemp += absI;
    }

    public static void movePower(double power, ThermalLoad from, ThermalLoad to) {
        double absI = Math.abs(power);
        from.PcTemp -= power;
        to.PcTemp += power;
        from.PspTemp += absI;
        to.PspTemp += absI;
    }

    public void movePowerTo(double power) {
        double absI = Math.abs(power);
        this.PcTemp += power;
        this.PspTemp += absI;
    }

    public double getT() {
        return this.Tc;
    }

    public boolean isSlow() {
        return this.isSlow;
    }

    public void setAsSlow() {
        this.isSlow = true;
    }

    public void setAsFast() {
        this.isSlow = false;
    }
}

