/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim;

import mods.eln.Eln;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;

public class ThermalLoadInitializer {
    public double warmLimit;
    public double coolLimit;
    double heatingTao;
    double conductionTao;
    double Rs;
    double Rp;
    double C;

    public ThermalLoadInitializer(double warmLimit, double coolLimit, double heatingTao, double conductionTao) {
        this.conductionTao = conductionTao;
        this.coolLimit = coolLimit;
        this.heatingTao = heatingTao;
        this.warmLimit = warmLimit;
    }

    public void setMaximalPower(double P) {
        this.C = P * this.heatingTao / this.warmLimit;
        this.Rp = this.warmLimit / P;
        this.Rs = this.conductionTao / this.C / 2.0;
        Eln.simulator.checkThermalLoad(this.Rs, this.Rp, this.C);
    }

    public void applyTo(ThermalLoad load) {
        load.set(this.Rs, this.Rp, this.C);
    }

    public void applyTo(ThermalLoadWatchDog doggy) {
        doggy.set(this);
    }

    public ThermalLoadInitializer copy() {
        ThermalLoadInitializer thermalLoad = new ThermalLoadInitializer(this.warmLimit, this.coolLimit, this.heatingTao, this.conductionTao);
        thermalLoad.Rp = this.Rp;
        thermalLoad.Rs = this.Rs;
        thermalLoad.C = this.C;
        return thermalLoad;
    }
}

