/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim;

import mods.eln.Eln;
import mods.eln.sim.ThermalLoad;

public class ThermalLoadInitializerByPowerDrop {
    public double warmLimit;
    public double coolLimit;
    double heatingTao;
    double TConductivityDrop;
    public double Rs;
    public double Rp;
    public double C;

    public ThermalLoadInitializerByPowerDrop(double warmLimit, double coolLimit, double heatingTao, double TConductivityDrop) {
        this.TConductivityDrop = TConductivityDrop;
        this.coolLimit = coolLimit;
        this.heatingTao = heatingTao;
        this.warmLimit = warmLimit;
    }

    public void setMaximalPower(double P) {
        this.C = P * this.heatingTao / this.warmLimit;
        this.Rp = this.warmLimit / P;
        this.Rs = this.TConductivityDrop / P / 2.0;
        Eln.simulator.checkThermalLoad(this.Rs, this.Rp, this.C);
    }

    public void applyTo(ThermalLoad load) {
        load.set(this.Rs, this.Rp, this.C);
    }

    public ThermalLoadInitializerByPowerDrop copy() {
        ThermalLoadInitializerByPowerDrop thermalLoad = new ThermalLoadInitializerByPowerDrop(this.warmLimit, this.coolLimit, this.heatingTao, this.TConductivityDrop);
        thermalLoad.Rp = this.Rp;
        thermalLoad.Rs = this.Rs;
        thermalLoad.C = this.C;
        return thermalLoad;
    }
}

