/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim;

import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;

public class ThermalResistor
implements IProcess {
    ThermalLoad a;
    ThermalLoad b;
    protected double R;
    protected double Rinv;

    public ThermalResistor(ThermalLoad a, ThermalLoad b) {
        this.a = a;
        this.b = b;
        this.highImpedance();
    }

    @Override
    public void process(double time) {
        double P = (this.a.Tc - this.b.Tc) * this.Rinv;
        this.a.PcTemp -= P;
        this.b.PcTemp += P;
    }

    public double getP() {
        return (this.a.Tc - this.b.Tc) * this.Rinv;
    }

    public void setR(double r) {
        this.R = r;
        this.Rinv = 1.0 / r;
    }

    public double getR() {
        return this.R;
    }

    public void highImpedance() {
        this.setR(1.0E9);
    }
}

