/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim;

import mods.eln.Eln;
import mods.eln.sim.IProcess;
import mods.eln.sim.ITimeRemoverObserver;

public class TimeRemover
implements IProcess {
    ITimeRemoverObserver observer;
    double timeout = 0.0;

    public TimeRemover(ITimeRemoverObserver observer) {
        this.observer = observer;
    }

    public void setTimeout(double timeout) {
        if (this.timeout <= 0.0) {
            this.observer.timeRemoverAdd();
            Eln.simulator.addSlowProcess(this);
        }
        this.timeout = timeout;
    }

    @Override
    public void process(double time) {
        if (this.isArmed()) {
            this.timeout -= time;
            if (this.timeout <= 0.0) {
                this.shot();
            }
        }
    }

    public boolean isArmed() {
        return this.timeout > 0.0;
    }

    public void shot() {
        this.timeout = 0.0;
        this.observer.timeRemoverRemove();
        Eln.simulator.removeSlowProcess(this);
    }
}

