/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.mna;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import mods.eln.libs.org.apache.commons.math3.linear.MatrixUtils;
import mods.eln.libs.org.apache.commons.math3.linear.QRDecomposition;
import mods.eln.libs.org.apache.commons.math3.linear.RealMatrix;
import mods.eln.misc.Profiler;
import mods.eln.misc.Utils;
import mods.eln.sim.mna.RootSystem;
import mods.eln.sim.mna.component.Component;
import mods.eln.sim.mna.component.Delay;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.mna.misc.IDestructor;
import mods.eln.sim.mna.misc.ISubSystemProcessFlush;
import mods.eln.sim.mna.misc.ISubSystemProcessI;
import mods.eln.sim.mna.state.State;
import mods.eln.sim.mna.state.VoltageState;

public class SubSystem {
    public ArrayList<Component> component = new ArrayList();
    public List<State> states = new ArrayList<State>();
    public LinkedList<IDestructor> breakDestructor = new LinkedList();
    public ArrayList<SubSystem> interSystemConnectivity = new ArrayList();
    ArrayList<ISubSystemProcessI> processI = new ArrayList();
    State[] statesTab;
    RootSystem root;
    double dt;
    boolean matrixValid = false;
    int stateCount;
    RealMatrix A;
    boolean singularMatrix;
    double[][] AInvdata;
    double[] Idata;
    double[] XtempData;
    boolean breaked = false;
    ArrayList<ISubSystemProcessFlush> processF = new ArrayList();

    public RootSystem getRoot() {
        return this.root;
    }

    public SubSystem(RootSystem root, double dt) {
        this.dt = dt;
        this.root = root;
    }

    public void invalidate() {
        this.matrixValid = false;
    }

    public void addComponent(Component c) {
        this.component.add(c);
        c.addedTo(this);
        this.invalidate();
    }

    public void addState(State s) {
        this.states.add(s);
        s.addedTo(this);
        this.invalidate();
    }

    public void removeComponent(Component c) {
        this.component.remove(c);
        c.quitSubSystem();
        this.invalidate();
    }

    public void removeState(State s) {
        this.states.remove(s);
        s.quitSubSystem();
        this.invalidate();
    }

    public void removeProcess(ISubSystemProcessI p) {
        this.processI.remove(p);
        this.invalidate();
    }

    public void addComponent(Iterable<Component> i) {
        for (Component c : i) {
            this.addComponent(c);
        }
    }

    public void addState(Iterable<State> i) {
        for (State s : i) {
            this.addState(s);
        }
    }

    public void addProcess(ISubSystemProcessI p) {
        this.processI.add(p);
    }

    public void generateMatrix() {
        Profiler p;
        block4: {
            this.stateCount = this.states.size();
            p = new Profiler();
            p.add("Inversse with " + this.stateCount + " state : ");
            this.A = MatrixUtils.createRealMatrix(this.stateCount, this.stateCount);
            this.Idata = new double[this.stateCount];
            this.XtempData = new double[this.stateCount];
            int idx = 0;
            for (State s : this.states) {
                s.setId(idx++);
            }
            for (Component c : this.component) {
                c.applyTo(this);
            }
            try {
                RealMatrix Ainv = new QRDecomposition(this.A).getSolver().getInverse();
                this.AInvdata = Ainv.getData();
                this.singularMatrix = false;
            }
            catch (Exception e) {
                this.singularMatrix = true;
                if (this.stateCount <= 1) break block4;
                int idx2 = 0;
                ++idx2;
                Utils.println("//////////SingularMatrix////////////");
            }
        }
        this.statesTab = new State[this.stateCount];
        this.statesTab = this.states.toArray(this.statesTab);
        this.matrixValid = true;
        p.stop();
        Utils.println(p);
    }

    public void addToA(State a, State b, double v) {
        if (a == null || b == null) {
            return;
        }
        this.A.addToEntry(a.getId(), b.getId(), v);
    }

    public void addToI(State s, double v) {
        if (s == null) {
            return;
        }
        this.Idata[s.getId()] = v;
    }

    public void step() {
        this.stepCalc();
        this.stepFlush();
    }

    public void stepCalc() {
        Profiler profiler = new Profiler();
        if (!this.matrixValid) {
            this.generateMatrix();
        }
        if (!this.singularMatrix) {
            for (int y = 0; y < this.stateCount; ++y) {
                this.Idata[y] = 0.0;
            }
            for (ISubSystemProcessI p : this.processI) {
                p.simProcessI(this);
            }
            for (int idx2 = 0; idx2 < this.stateCount; ++idx2) {
                double stack = 0.0;
                for (int idx = 0; idx < this.stateCount; ++idx) {
                    stack += this.AInvdata[idx2][idx] * this.Idata[idx];
                }
                this.XtempData[idx2] = stack;
            }
        }
        profiler.stop();
    }

    public double solve(State pin) {
        if (!this.matrixValid) {
            this.generateMatrix();
        }
        if (!this.singularMatrix) {
            for (int y = 0; y < this.stateCount; ++y) {
                this.Idata[y] = 0.0;
            }
            for (ISubSystemProcessI p : this.processI) {
                p.simProcessI(this);
            }
            int idx2 = pin.getId();
            double stack = 0.0;
            for (int idx = 0; idx < this.stateCount; ++idx) {
                stack += this.AInvdata[idx2][idx] * this.Idata[idx];
            }
            return stack;
        }
        return 0.0;
    }

    public void stepFlush() {
        int idx;
        if (!this.singularMatrix) {
            for (idx = 0; idx < this.stateCount; ++idx) {
                this.statesTab[idx].state = this.XtempData[idx];
            }
        } else {
            for (idx = 0; idx < this.stateCount; ++idx) {
                this.statesTab[idx].state = 0.0;
            }
        }
        for (ISubSystemProcessFlush p : this.processF) {
            p.simProcessFlush();
        }
    }

    public static void main(String[] args) {
        SubSystem s = new SubSystem(null, 0.1);
        VoltageState n1 = new VoltageState();
        s.addState(n1);
        VoltageState n2 = new VoltageState();
        s.addState(n2);
        VoltageState n3 = new VoltageState();
        s.addState(n3);
        VoltageSource u1 = new VoltageSource("");
        s.addComponent(u1.setU(1.0).connectTo(n1, null));
        Resistor r1 = new Resistor();
        s.addComponent(r1.setR(10.0).connectTo(n1, n2));
        Delay d1 = new Delay();
        s.addComponent(d1.set(1.0).connectTo(n2, n3));
        Resistor r2 = new Resistor();
        s.addComponent(r2.setR(10.0).connectTo(n3, null));
        for (int idx = 0; idx < 100; ++idx) {
            s.step();
        }
        System.out.println("END");
        s.step();
        s.step();
        s.step();
    }

    public boolean containe(State state) {
        return this.states.contains(state);
    }

    public void setX(State s, double value) {
        s.state = value;
    }

    public double getX(State s) {
        return s.state;
    }

    public double getXSafe(State bPin) {
        return bPin == null ? 0.0 : this.getX(bPin);
    }

    public boolean breakSystem() {
        if (this.breaked) {
            return false;
        }
        while (!this.breakDestructor.isEmpty()) {
            this.breakDestructor.pop().destruct();
        }
        for (Component c : this.component) {
            c.quitSubSystem();
        }
        for (State s : this.states) {
            s.quitSubSystem();
        }
        if (this.root != null) {
            for (Component c : this.component) {
                c.returnToRootSystem(this.root);
            }
            for (State s : this.states) {
                s.returnToRootSystem(this.root);
            }
        }
        this.root.systems.remove(this);
        this.invalidate();
        this.breaked = true;
        return true;
    }

    public void addProcess(ISubSystemProcessFlush p) {
        this.processF.add(p);
    }

    public void removeProcess(ISubSystemProcessFlush p) {
        this.processF.remove(p);
    }

    public double getDt() {
        return this.dt;
    }

    public Th getTh(State d, VoltageSource voltageSource) {
        double Uth;
        Th th = new Th();
        double originalU = d.state;
        double aU = 10.0;
        voltageSource.setU(aU);
        double aI = this.solve(voltageSource.getCurrentState());
        double bU = 5.0;
        voltageSource.setU(bU);
        double bI = this.solve(voltageSource.getCurrentState());
        double Rth = (aU - bU) / (bI - aI);
        if (Rth > 1.0E19 || Rth < 0.0) {
            Uth = 0.0;
            Rth = 1.0E19;
        } else {
            Uth = aU + Rth * aI;
        }
        voltageSource.setU(originalU);
        th.R = Rth;
        th.U = Uth;
        return th;
    }

    public static class Th {
        public double R;
        public double U;

        public boolean isHighImpedance() {
            return this.R > 1.0E8;
        }
    }
}

