/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.mna.component;

import mods.eln.sim.mna.component.Component;
import mods.eln.sim.mna.state.State;

public abstract class Bipole
extends Component {
    public State aPin;
    public State bPin;

    public Bipole() {
    }

    public Bipole(State aPin, State bPin) {
        this.connectTo(aPin, bPin);
    }

    public Bipole connectTo(State aPin, State bPin) {
        this.breakConnection();
        this.aPin = aPin;
        this.bPin = bPin;
        if (aPin != null) {
            aPin.add(this);
        }
        if (bPin != null) {
            bPin.add(this);
        }
        return this;
    }

    public Bipole connectGhostTo(State aPin, State bPin) {
        this.breakConnection();
        this.aPin = aPin;
        this.bPin = bPin;
        return this;
    }

    @Override
    public void breakConnection() {
        if (this.aPin != null) {
            this.aPin.remove(this);
        }
        if (this.bPin != null) {
            this.bPin.remove(this);
        }
    }

    @Override
    public State[] getConnectedStates() {
        return new State[]{this.aPin, this.bPin};
    }

    public abstract double getCurrent();

    public double getU() {
        return (this.aPin == null ? 0.0 : this.aPin.state) - (this.bPin == null ? 0.0 : this.bPin.state);
    }

    public double getBipoleU() {
        return this.getU();
    }
}

