/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.mna.component;

import mods.eln.sim.mna.SubSystem;
import mods.eln.sim.mna.component.Bipole;
import mods.eln.sim.mna.misc.ISubSystemProcessI;
import mods.eln.sim.mna.state.State;

public class Capacitor
extends Bipole
implements ISubSystemProcessI {
    private double c = 0.0;
    double cdt;

    public Capacitor() {
    }

    public Capacitor(State aPin, State bPin) {
        this.connectTo(aPin, bPin);
    }

    @Override
    public double getCurrent() {
        return 0.0;
    }

    public void setC(double c) {
        this.c = c;
        this.dirty();
    }

    @Override
    public void applyTo(SubSystem s) {
        this.cdt = this.c / s.getDt();
        s.addToA(this.aPin, this.aPin, this.cdt);
        s.addToA(this.aPin, this.bPin, -this.cdt);
        s.addToA(this.bPin, this.bPin, this.cdt);
        s.addToA(this.bPin, this.aPin, -this.cdt);
    }

    @Override
    public void simProcessI(SubSystem s) {
        double add = (s.getXSafe(this.aPin) - s.getXSafe(this.bPin)) * this.cdt;
        s.addToI(this.aPin, add);
        s.addToI(this.bPin, -add);
    }

    @Override
    public void quitSubSystem() {
        this.subSystem.removeProcess(this);
        super.quitSubSystem();
    }

    @Override
    public void addedTo(SubSystem s) {
        super.addedTo(s);
        s.addProcess(this);
    }

    public double getE() {
        double u = this.getU();
        return u * u * this.c / 2.0;
    }

    public double getC() {
        return this.c;
    }
}

