/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.mna.component;

import mods.eln.sim.mna.SubSystem;
import mods.eln.sim.mna.component.Bipole;
import mods.eln.sim.mna.misc.ISubSystemProcessI;

public class Delay
extends Bipole
implements ISubSystemProcessI {
    double impedance;
    double conductance;
    double oldIa;
    double oldIb;

    public Delay set(double impedance) {
        this.impedance = impedance;
        this.conductance = 1.0 / impedance;
        return this;
    }

    @Override
    public void addedTo(SubSystem s) {
        super.addedTo(s);
        s.addProcess(this);
    }

    @Override
    public void applyTo(SubSystem s) {
        s.addToA(this.aPin, this.aPin, this.conductance);
        s.addToA(this.bPin, this.bPin, this.conductance);
    }

    @Override
    public void simProcessI(SubSystem s) {
        double iA = this.aPin.state * this.conductance + this.oldIa;
        double iB = this.bPin.state * this.conductance + this.oldIb;
        double iTarget = (iA - iB) / 2.0;
        double aPinI = iTarget - (this.aPin.state + this.bPin.state) * 0.5 * this.conductance;
        double bPinI = -iTarget - (this.aPin.state + this.bPin.state) * 0.5 * this.conductance;
        s.addToI(this.aPin, -aPinI);
        s.addToI(this.bPin, -bPinI);
        this.oldIa = aPinI;
        this.oldIb = bPinI;
    }

    @Override
    public double getCurrent() {
        return this.oldIa - this.oldIb;
    }
}

