/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.mna.component;

import mods.eln.sim.mna.SubSystem;
import mods.eln.sim.mna.component.Component;
import mods.eln.sim.mna.misc.IRootSystemPreStepProcess;
import mods.eln.sim.mna.misc.ISubSystemProcessI;
import mods.eln.sim.mna.state.State;

public class DelayInterSystem
extends Component
implements ISubSystemProcessI {
    private DelayInterSystem other;
    public State pin;
    double impedance;
    double conductance;
    public double[] oldIother = new double[]{0.0, 0.0};
    int doubleBuffer = 0;
    public boolean thevnaCalc = false;
    public double thenvaCurrent;
    public double Rth;
    public double Uth;
    double iTarget;

    public void set(State pin, DelayInterSystem other) {
        this.other = other;
        this.pin = pin;
    }

    public DelayInterSystem set(double impedance) {
        this.impedance = impedance;
        this.conductance = 1.0 / impedance;
        return this;
    }

    @Override
    public void quitSubSystem() {
        this.subSystem.removeProcess(this);
        super.quitSubSystem();
    }

    @Override
    public void addedTo(SubSystem s) {
        super.addedTo(s);
        s.addProcess(this);
    }

    @Override
    public void applyTo(SubSystem s) {
        s.addToA(this.pin, this.pin, this.conductance);
    }

    @Override
    public State[] getConnectedStates() {
        return new State[0];
    }

    public void setInitialCurrent(double i) {
        this.oldIother[this.doubleBuffer] = i;
    }

    @Override
    public void simProcessI(SubSystem s) {
        if (!this.thevnaCalc) {
            if (Math.abs(this.Rth) < 1000000.0) {
                double uTarget = this.Uth - this.Rth * this.iTarget;
                double aPinI = this.iTarget - uTarget * this.conductance;
                s.addToI(this.pin, -aPinI);
            } else {
                double uTarget = this.other.pin.state * 0.5 + this.pin.state * 0.5;
                double aPinI = this.iTarget - uTarget * this.conductance;
                s.addToI(this.pin, -aPinI);
            }
        } else {
            s.addToI(this.pin, -this.thenvaCurrent);
        }
    }

    public static class ThevnaCalculator
    implements IRootSystemPreStepProcess {
        DelayInterSystem a;
        DelayInterSystem b;

        public ThevnaCalculator(DelayInterSystem a, DelayInterSystem b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public void rootSystemPreStepProcess() {
            double iTarget;
            this.doJobFor(this.a);
            this.doJobFor(this.b);
            this.a.iTarget = iTarget = (this.a.Uth - this.b.Uth) / (this.a.Rth + this.b.Rth);
            this.b.iTarget = -iTarget;
        }

        void doJobFor(DelayInterSystem d) {
            d.thevnaCalc = true;
            d.thenvaCurrent = 2.0;
            double aIs = 2.0;
            double aU = d.getSubSystem().solve(d.pin);
            d.thenvaCurrent = 1.0;
            double bIs = 1.0;
            double bU = d.getSubSystem().solve(d.pin);
            double aC = -(aU * d.conductance + aIs);
            double bC = -(bU * d.conductance + bIs);
            d.Rth = (aU - bU) / (aC - bC);
            d.Uth = aU - d.Rth * aC;
            d.thevnaCalc = false;
        }
    }
}

