/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.mna.component;

import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.mna.misc.IRootSystemPreStepProcess;

public class DelayInterSystem2
extends VoltageSource {
    private DelayInterSystem2 other;
    public double Rth;
    public double Uth;
    public boolean thevnaCalc = false;

    public DelayInterSystem2() {
        super(null);
    }

    public void set(DelayInterSystem2 other) {
        this.other = other;
    }

    public static class ThevnaCalculator
    implements IRootSystemPreStepProcess {
        DelayInterSystem2 a;
        DelayInterSystem2 b;

        public ThevnaCalculator(DelayInterSystem2 a, DelayInterSystem2 b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public void rootSystemPreStepProcess() {
            this.doJobFor(this.a);
            this.doJobFor(this.b);
            double U = (this.a.Uth - this.b.Uth) * this.b.Rth / (this.a.Rth + this.b.Rth) + this.b.Uth;
            if (Double.isNaN(U)) {
                U = 0.0;
            }
            this.a.setU(U);
            this.b.setU(U);
        }

        void doJobFor(DelayInterSystem2 d) {
            double originalU = d.getU();
            double aU = 10.0;
            d.setU(aU);
            double aI = d.getSubSystem().solve(d.getCurrentState());
            double bU = 5.0;
            d.setU(bU);
            double bI = d.getSubSystem().solve(d.getCurrentState());
            d.Rth = (aU - bU) / (bI - aI);
            if (d.Rth > 1.0E19) {
                d.Uth = 0.0;
                d.Rth = 1.0E19;
            } else {
                d.Uth = aU + d.Rth * aI;
            }
            d.setU(originalU);
        }
    }
}

