/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.mna.component;

import mods.eln.sim.mna.RootSystem;
import mods.eln.sim.mna.SubSystem;
import mods.eln.sim.mna.component.Component;
import mods.eln.sim.mna.component.DelayInterSystem2;
import mods.eln.sim.mna.component.IAbstractor;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.mna.misc.IDestructor;
import mods.eln.sim.mna.state.State;
import mods.eln.sim.mna.state.VoltageState;

public class InterSystemAbstraction
implements IAbstractor,
IDestructor {
    VoltageState aNewState;
    Resistor aNewResistor;
    DelayInterSystem2 aNewDelay;
    VoltageState bNewState;
    Resistor bNewResistor;
    DelayInterSystem2 bNewDelay;
    DelayInterSystem2.ThevnaCalculator thevnaCalc;
    RootSystem root;
    Resistor interSystemResistor;
    State aState;
    State bState;
    SubSystem aSystem;
    SubSystem bSystem;

    public InterSystemAbstraction(RootSystem root, Resistor interSystemResistor) {
        this.interSystemResistor = interSystemResistor;
        this.root = root;
        this.aState = interSystemResistor.aPin;
        this.bState = interSystemResistor.bPin;
        this.aSystem = this.aState.getSubSystem();
        this.bSystem = this.bState.getSubSystem();
        this.aSystem.interSystemConnectivity.add(this.bSystem);
        this.bSystem.interSystemConnectivity.add(this.aSystem);
        this.aNewState = new VoltageState();
        this.aNewResistor = new Resistor();
        this.aNewDelay = new DelayInterSystem2();
        this.bNewState = new VoltageState();
        this.bNewResistor = new Resistor();
        this.bNewDelay = new DelayInterSystem2();
        this.aNewResistor.connectGhostTo(this.aState, this.aNewState);
        this.aNewDelay.connectTo(this.aNewState, null);
        this.bNewResistor.connectGhostTo(this.bState, this.bNewState);
        this.bNewDelay.connectTo(this.bNewState, null);
        this.calibrate();
        this.aSystem.addComponent(this.aNewResistor);
        this.aSystem.addState(this.aNewState);
        this.aSystem.addComponent(this.aNewDelay);
        this.bSystem.addComponent(this.bNewResistor);
        this.bSystem.addState(this.bNewState);
        this.bSystem.addComponent(this.bNewDelay);
        this.aSystem.breakDestructor.add(this);
        this.bSystem.breakDestructor.add(this);
        interSystemResistor.abstractedBy = this;
        this.thevnaCalc = new DelayInterSystem2.ThevnaCalculator(this.aNewDelay, this.bNewDelay);
        root.addProcess(this.thevnaCalc);
    }

    void calibrate() {
        double u = (this.aState.state + this.bState.state) / 2.0;
        this.aNewDelay.setU(u);
        this.bNewDelay.setU(u);
        double r = this.interSystemResistor.getR() / 2.0;
        this.aNewResistor.setR(r);
        this.bNewResistor.setR(r);
    }

    @Override
    public void dirty(Component component) {
        this.calibrate();
    }

    @Override
    public SubSystem getAbstractorSubSystem() {
        return this.aSystem;
    }

    @Override
    public void destruct() {
        this.aSystem.breakDestructor.remove(this);
        this.aSystem.removeComponent(this.aNewDelay);
        this.aSystem.removeComponent(this.aNewResistor);
        this.aSystem.removeState(this.aNewState);
        this.bSystem.breakDestructor.remove(this);
        this.bSystem.removeComponent(this.bNewDelay);
        this.bSystem.removeComponent(this.bNewResistor);
        this.bSystem.removeState(this.bNewState);
        this.root.removeProcess(this.thevnaCalc);
        this.interSystemResistor.abstractedBy = null;
        this.aSystem.component.add(this.interSystemResistor);
    }
}

