/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.mna.component;

import java.util.Iterator;
import java.util.LinkedList;
import mods.eln.sim.mna.RootSystem;
import mods.eln.sim.mna.SubSystem;
import mods.eln.sim.mna.component.Component;
import mods.eln.sim.mna.component.IAbstractor;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.mna.misc.ISubSystemProcessFlush;
import mods.eln.sim.mna.state.State;

public class Line
extends Resistor
implements ISubSystemProcessFlush,
IAbstractor {
    public LinkedList<Resistor> resistors = new LinkedList();
    public LinkedList<State> states = new LinkedList();
    boolean ofInterSystem;

    boolean canAdd(Component c) {
        return c instanceof Resistor;
    }

    void add(Resistor c) {
        this.ofInterSystem |= c.canBeReplacedByInterSystem();
        this.resistors.add(c);
    }

    @Override
    public boolean canBeReplacedByInterSystem() {
        return this.ofInterSystem;
    }

    public void recalculateR() {
        double R = 0.0;
        for (Resistor r : this.resistors) {
            R += r.getR();
        }
        this.setR(R);
    }

    void restoreResistorIntoCircuit() {
        this.breakConnection();
    }

    void removeResistorFromCircuit() {
    }

    public static void newLine(RootSystem root, LinkedList<Resistor> resistors, LinkedList<State> states) {
        if (!resistors.isEmpty() && resistors.size() != 1) {
            Resistor first = resistors.getFirst();
            Resistor last = resistors.getLast();
            State stateBefore = first.aPin == states.getFirst() ? first.bPin : first.aPin;
            State stateAfter = last.aPin == states.getLast() ? last.bPin : last.aPin;
            Line l = new Line();
            l.resistors = resistors;
            l.states = states;
            l.recalculateR();
            root.addComponents.removeAll(resistors);
            root.addStates.removeAll(states);
            root.addComponents.add(l);
            l.connectTo(stateBefore, stateAfter);
            l.removeResistorFromCircuit();
            root.addProcess(l);
            for (Resistor r : resistors) {
                r.abstractedBy = l;
                l.ofInterSystem |= r.canBeReplacedByInterSystem();
            }
            for (State s : states) {
                s.abstractedBy = l;
            }
        }
    }

    @Override
    public void returnToRootSystem(RootSystem root) {
        for (Resistor r : this.resistors) {
            r.abstractedBy = null;
        }
        for (State s : this.states) {
            s.abstractedBy = null;
        }
        this.restoreResistorIntoCircuit();
        root.addStates.addAll(this.states);
        root.addComponents.addAll(this.resistors);
        root.removeProcess(this);
    }

    @Override
    public void simProcessFlush() {
        double i = (this.aPin.state - this.bPin.state) * this.getRInv();
        double u = this.aPin.state;
        Iterator ir = this.resistors.iterator();
        for (State s : this.states) {
            Resistor r = (Resistor)ir.next();
            s.state = u -= r.getR() * i;
        }
    }

    @Override
    public void addedTo(SubSystem s) {
        s.addProcess(this);
        super.addedTo(s);
    }

    @Override
    public void quitSubSystem() {
    }

    @Override
    public void dirty(Component component) {
        this.recalculateR();
        if (this.isAbstracted()) {
            this.abstractedBy.dirty(this);
        }
    }

    @Override
    public SubSystem getAbstractorSubSystem() {
        return this.getSubSystem();
    }
}

