/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.mna.component;

import mods.eln.misc.INBTTReady;
import mods.eln.sim.mna.SubSystem;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.mna.misc.IRootSystemPreStepProcess;
import mods.eln.sim.mna.state.State;
import net.minecraft.nbt.NBTTagCompound;

public class PowerSource
extends VoltageSource
implements IRootSystemPreStepProcess,
INBTTReady {
    String name;
    double P;
    double Umax;
    double Imax;

    public PowerSource(String name, State aPin) {
        super(name, aPin, null);
        this.name = name;
    }

    public void setP(double P) {
        this.P = P;
    }

    void setMax(double Umax, double Imax) {
        this.Umax = Umax;
        this.Imax = Imax;
    }

    public void setImax(double imax) {
        this.Imax = imax;
    }

    public void setUmax(double umax) {
        this.Umax = umax;
    }

    @Override
    public double getP() {
        return this.P;
    }

    @Override
    public void quitSubSystem() {
        this.getSubSystem().getRoot().removeProcess(this);
        super.quitSubSystem();
    }

    @Override
    public void addedTo(SubSystem s) {
        super.addedTo(s);
        this.getSubSystem().getRoot().addProcess(this);
        s.addProcess(this);
    }

    @Override
    public void rootSystemPreStepProcess() {
        SubSystem.Th t = this.aPin.getSubSystem().getTh(this.aPin, this);
        double U = (Math.sqrt(t.U * t.U + 4.0 * this.P * t.R) + t.U) / 2.0;
        if (Double.isNaN(U = Math.min(Math.min(U, this.Umax), t.U + t.R * this.Imax))) {
            U = 0.0;
        }
        if (U < t.U) {
            U = t.U;
        }
        this.setU(U);
    }

    public double getEffectiveP() {
        return this.getBipoleU() * this.getCurrent();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String str) {
        super.readFromNBT(nbt, str);
        str = str + this.name;
        this.setP(nbt.func_74769_h(str + "P"));
        this.setUmax(nbt.func_74769_h(str + "Umax"));
        this.setImax(nbt.func_74769_h(str + "Imax"));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String str) {
        super.writeToNBT(nbt, str);
        str = str + this.name;
        nbt.func_74780_a(str + "P", this.getP());
        nbt.func_74780_a(str + "Umax", this.Umax);
        nbt.func_74780_a(str + "Imax", this.Imax);
    }
}

