/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.mna.component;

import mods.eln.sim.mna.SubSystem;
import mods.eln.sim.mna.component.Bipole;
import mods.eln.sim.mna.state.State;

public class Resistor
extends Bipole {
    private double r = 1.0E9;
    private double rInv = 1.0E-9;

    public Resistor() {
    }

    public Resistor(State aPin, State bPin) {
        super(aPin, bPin);
    }

    public double getRInv() {
        return this.rInv;
    }

    public double getR() {
        return this.r;
    }

    public double getI() {
        return this.getCurrent();
    }

    public double getP() {
        return this.getU() * this.getCurrent();
    }

    @Override
    public double getU() {
        return (this.aPin == null ? 0.0 : this.aPin.state) - (this.bPin == null ? 0.0 : this.bPin.state);
    }

    public Resistor setR(double r) {
        if (this.r != r) {
            this.r = r;
            this.rInv = 1.0 / r;
            this.dirty();
        }
        return this;
    }

    public void highImpedance() {
        this.setR(1.0E9);
    }

    public void ultraImpedance() {
        this.setR(1.0E16);
    }

    public Resistor pullDown() {
        this.setR(1.0E9);
        return this;
    }

    boolean canBridge() {
        return false;
    }

    @Override
    public void applyTo(SubSystem s) {
        s.addToA(this.aPin, this.aPin, this.rInv);
        s.addToA(this.aPin, this.bPin, -this.rInv);
        s.addToA(this.bPin, this.bPin, this.rInv);
        s.addToA(this.bPin, this.aPin, -this.rInv);
    }

    @Override
    public double getCurrent() {
        return this.getU() * this.rInv;
    }
}

