/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.mna.component;

import mods.eln.misc.INBTTReady;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.mna.state.State;
import net.minecraft.nbt.NBTTagCompound;

public class ResistorSwitch
extends Resistor
implements INBTTReady {
    boolean ultraImpedance = false;
    String name;
    boolean state = false;
    protected double baseR = 1.0;

    public ResistorSwitch(String name, State aPin, State bPin) {
        super(aPin, bPin);
        this.name = name;
    }

    public void setState(boolean state) {
        this.state = state;
        this.setR(this.baseR);
    }

    @Override
    public Resistor setR(double r) {
        this.baseR = r;
        return super.setR(this.state ? r : (this.ultraImpedance ? 1.0E16 : 1.0E9));
    }

    public boolean getState() {
        return this.state;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String str) {
        str = str + this.name;
        this.setR(nbt.func_74769_h(str + "R"));
        if (Double.isNaN(this.baseR) || this.baseR == 0.0) {
            if (this.ultraImpedance) {
                this.ultraImpedance();
            } else {
                this.highImpedance();
            }
        }
        this.setState(nbt.func_74767_n(str + "State"));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String str) {
        str = str + this.name;
        nbt.func_74780_a(str + "R", this.baseR);
        nbt.func_74757_a(str + "State", this.getState());
    }

    public void mustUseUltraImpedance() {
        this.ultraImpedance = true;
    }
}

