/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.mna.component;

import mods.eln.misc.INBTTReady;
import mods.eln.sim.mna.SubSystem;
import mods.eln.sim.mna.component.Bipole;
import mods.eln.sim.mna.misc.ISubSystemProcessI;
import mods.eln.sim.mna.state.CurrentState;
import mods.eln.sim.mna.state.State;
import net.minecraft.nbt.NBTTagCompound;

public class VoltageSource
extends Bipole
implements ISubSystemProcessI,
INBTTReady {
    String name;
    double u = 0.0;
    private CurrentState currentState = new CurrentState();

    public VoltageSource(String name) {
        this.name = name;
    }

    public VoltageSource(String name, State aPin, State bPin) {
        super(aPin, bPin);
        this.name = name;
    }

    public VoltageSource setU(double u) {
        this.u = u;
        return this;
    }

    @Override
    public double getU() {
        return this.u;
    }

    @Override
    public void quitSubSystem() {
        this.subSystem.states.remove(this.getCurrentState());
        this.subSystem.removeProcess(this);
        super.quitSubSystem();
    }

    @Override
    public void addedTo(SubSystem s) {
        super.addedTo(s);
        s.addState(this.getCurrentState());
        s.addProcess(this);
    }

    @Override
    public void applyTo(SubSystem s) {
        s.addToA(this.aPin, this.getCurrentState(), 1.0);
        s.addToA(this.bPin, this.getCurrentState(), -1.0);
        s.addToA(this.getCurrentState(), this.aPin, 1.0);
        s.addToA(this.getCurrentState(), this.bPin, -1.0);
    }

    @Override
    public void simProcessI(SubSystem s) {
        s.addToI(this.getCurrentState(), this.u);
    }

    public double getI() {
        return -this.getCurrentState().state;
    }

    @Override
    public double getCurrent() {
        return -this.getCurrentState().state;
    }

    public CurrentState getCurrentState() {
        return this.currentState;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String str) {
        str = str + this.name;
        this.setU(nbt.func_74769_h(str + "U"));
        this.currentState.state = nbt.func_74769_h(str + "Istate");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String str) {
        str = str + this.name;
        nbt.func_74780_a(str + "U", this.u);
        nbt.func_74780_a(str + "Istate", this.currentState.state);
    }

    public double getP() {
        return this.getU() * this.getI();
    }
}

