/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.mna.process;

import mods.eln.misc.INBTTReady;
import mods.eln.sim.mna.SubSystem;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.mna.misc.IRootSystemPreStepProcess;
import mods.eln.sim.mna.state.State;
import net.minecraft.nbt.NBTTagCompound;

public class PowerSourceBipole
implements IRootSystemPreStepProcess,
INBTTReady {
    private VoltageSource aSrc;
    private VoltageSource bSrc;
    private State aPin;
    private State bPin;
    double P;
    double Umax;
    double Imax;

    public PowerSourceBipole(State aPin, State bPin, VoltageSource aSrc, VoltageSource bSrc) {
        this.aSrc = aSrc;
        this.bSrc = bSrc;
        this.aPin = aPin;
        this.bPin = bPin;
    }

    public void setP(double P) {
        this.P = P;
    }

    void setMax(double Umax, double Imax) {
        this.Umax = Umax;
        this.Imax = Imax;
    }

    public void setImax(double imax) {
        this.Imax = imax;
    }

    public void setUmax(double umax) {
        this.Umax = umax;
    }

    public double getP() {
        return this.P;
    }

    @Override
    public void rootSystemPreStepProcess() {
        SubSystem.Th a = this.aPin.getSubSystem().getTh(this.aPin, this.aSrc);
        SubSystem.Th b = this.bPin.getSubSystem().getTh(this.bPin, this.bSrc);
        double Uth = a.U - b.U;
        double Rth = a.R + b.R;
        if (Uth >= this.Umax) {
            this.aSrc.setU(a.U);
            this.bSrc.setU(b.U);
        } else {
            double U = (Math.sqrt(Uth * Uth + 4.0 * this.P * Rth) + Uth) / 2.0;
            if (Double.isNaN(U = Math.min(Math.min(U, this.Umax), Uth + Rth * this.Imax))) {
                U = 0.0;
            }
            double I = (Uth - U) / Rth;
            this.aSrc.setU(a.U - I * a.R);
            this.bSrc.setU(b.U + I * b.R);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String str) {
        this.setP(nbt.func_74769_h(str + "P"));
        this.setUmax(nbt.func_74769_h(str + "Umax"));
        this.setImax(nbt.func_74769_h(str + "Imax"));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String str) {
        nbt.func_74780_a(str + "P", this.getP());
        nbt.func_74780_a(str + "Umax", this.Umax);
        nbt.func_74780_a(str + "Imax", this.Imax);
    }
}

