/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.mna.process;

import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.mna.misc.IRootSystemPreStepProcess;
import mods.eln.sim.mna.state.State;

public class TransformerInterSystemProcess
implements IRootSystemPreStepProcess {
    State aState;
    State bState;
    VoltageSource aVoltgeSource;
    VoltageSource bVoltgeSource;
    double ratio = 1.0;

    public TransformerInterSystemProcess(State aState, State bState, VoltageSource aVoltgeSource, VoltageSource bVoltgeSource) {
        this.aState = aState;
        this.bState = bState;
        this.aVoltgeSource = aVoltgeSource;
        this.bVoltgeSource = bVoltgeSource;
    }

    @Override
    public void rootSystemPreStepProcess() {
        Th a = this.getTh(this.aState, this.aVoltgeSource);
        Th b = this.getTh(this.bState, this.bVoltgeSource);
        double aU = (a.U * b.R + this.ratio * b.U * a.R) / (b.R + this.ratio * this.ratio * a.R);
        if (Double.isNaN(aU)) {
            aU = 0.0;
        }
        this.aVoltgeSource.setU(aU);
        this.bVoltgeSource.setU(aU * this.ratio);
    }

    Th getTh(State d, VoltageSource voltageSource) {
        double Uth;
        Th th = new Th();
        double originalU = d.state;
        double aU = 10.0;
        voltageSource.setU(aU);
        double aI = d.getSubSystem().solve(voltageSource.getCurrentState());
        double bU = 5.0;
        voltageSource.setU(bU);
        double bI = d.getSubSystem().solve(voltageSource.getCurrentState());
        double Rth = (aU - bU) / (bI - aI);
        if (Rth > 1.0E19 || Rth < 0.0) {
            Uth = 0.0;
            Rth = 1.0E19;
        } else {
            Uth = aU + Rth * aI;
        }
        voltageSource.setU(originalU);
        th.R = Rth;
        th.U = Uth;
        return th;
    }

    public void setRatio(double ratio) {
        this.ratio = ratio;
    }

    static class Th {
        double R;
        double U;

        Th() {
        }
    }
}

