/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.mna.state;

import java.util.ArrayList;
import mods.eln.sim.mna.RootSystem;
import mods.eln.sim.mna.SubSystem;
import mods.eln.sim.mna.component.Component;
import mods.eln.sim.mna.component.IAbstractor;

public class State {
    private int id = -1;
    public double state;
    SubSystem subSystem;
    ArrayList<Component> components = new ArrayList();
    boolean isPrivateSubSystem = false;
    boolean mustBeFarFromInterSystem = false;
    public IAbstractor abstractedBy;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void addedTo(SubSystem s) {
        this.subSystem = s;
    }

    public SubSystem getSubSystem() {
        if (this.isAbstracted()) {
            return this.abstractedBy.getAbstractorSubSystem();
        }
        return this.subSystem;
    }

    public void quitSubSystem() {
        this.subSystem = null;
    }

    public ArrayList<Component> getConnectedComponents() {
        return this.components;
    }

    public ArrayList<Component> getConnectedComponentsNotAbstracted() {
        ArrayList<Component> list = new ArrayList<Component>();
        for (Component c : this.components) {
            if (c.isAbstracted()) continue;
            list.add(c);
        }
        return list;
    }

    public void add(Component c) {
        this.components.add(c);
    }

    public void remove(Component c) {
        this.components.remove(c);
    }

    public boolean canBeSimplifiedByLine() {
        return false;
    }

    public State setAsPrivate() {
        this.isPrivateSubSystem = true;
        return this;
    }

    public State setAsMustBeFarFromInterSystem() {
        this.mustBeFarFromInterSystem = true;
        return this;
    }

    public boolean mustBeFarFromInterSystem() {
        return this.mustBeFarFromInterSystem;
    }

    public boolean isPrivateSubSystem() {
        return this.isPrivateSubSystem;
    }

    public void returnToRootSystem(RootSystem root) {
        root.addStates.add(this);
    }

    public boolean isAbstracted() {
        return this.abstractedBy != null;
    }

    public boolean isNotSimulated() {
        return this.subSystem == null && this.abstractedBy == null;
    }
}

