/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.nbt;

import mods.eln.Eln;
import mods.eln.misc.INBTTReady;
import mods.eln.misc.Utils;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.mna.SubSystem;
import mods.eln.sim.mna.component.Capacitor;
import net.minecraft.nbt.NBTTagCompound;

public class NbtElectricalGateOutputProcess
extends Capacitor
implements INBTTReady {
    double U;
    String name;
    boolean highImpedance = false;

    public NbtElectricalGateOutputProcess(String name, ElectricalLoad positiveLoad) {
        super(positiveLoad, null);
        this.name = name;
        this.setHighImpedance(false);
    }

    public void setHighImpedance(boolean enable) {
        this.highImpedance = enable;
        double baseC = 0.1 / Eln.instance.electricalFrequency / 50.0;
        if (enable) {
            this.setC(baseC / 1000.0);
        } else {
            this.setC(baseC);
        }
    }

    @Override
    public void simProcessI(SubSystem s) {
        if (!this.highImpedance) {
            this.aPin.state = this.U;
        }
        super.simProcessI(s);
    }

    public boolean isHighImpedance() {
        return this.highImpedance;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String str) {
        this.setHighImpedance(nbt.func_74767_n(str + this.name + "highImpedance"));
        this.U = nbt.func_74769_h(str + this.name + "U");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String str) {
        nbt.func_74757_a(str + this.name + "highImpedance", this.highImpedance);
        nbt.func_74780_a(str + this.name + "U", this.U);
    }

    public void setOutputNormalized(double value) {
        this.setOutputNormalizedSafe(value);
    }

    public void state(boolean value) {
        this.U = value ? 50.0 : 0.0;
    }

    public double getOutputNormalized() {
        return this.U / 50.0;
    }

    public boolean getOutputOnOff() {
        return this.U >= 25.0;
    }

    public void setOutputNormalizedSafe(double value) {
        if (value > 1.0) {
            value = 1.0;
        }
        if (value < 0.0) {
            value = 0.0;
        }
        if (Double.isNaN(value)) {
            value = 0.0;
        }
        this.U = value * 50.0;
    }

    public void setU(double U) {
        this.U = U;
    }

    public void setUSafe(double value) {
        if (Double.isNaN(value = Utils.limit(value, 0.0, 50.0))) {
            value = 0.0;
        }
        this.U = value;
    }

    @Override
    public double getU() {
        return this.U;
    }
}

