/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.process.destruct;

import cpw.mods.fml.common.FMLLog;
import mods.eln.misc.Utils;
import mods.eln.sim.IProcess;
import mods.eln.sim.process.destruct.IDestructable;

public abstract class ValueWatchdog
implements IProcess {
    IDestructable destructable;
    double perOverflowStrenght = 1.0;
    double min;
    double max;
    double timeoutReset = 2.0;
    double timeout = 0.0;
    boolean boot = true;
    boolean joker = true;
    double rand = Utils.rand(0.5, 1.5);

    @Override
    public void process(double time) {
        double value;
        double overflow;
        if (this.boot) {
            this.boot = false;
            this.timeout = this.timeoutReset;
        }
        if ((overflow = Math.max((value = this.getValue()) - this.max, this.min - value)) > 0.0) {
            if (this.joker) {
                this.joker = false;
                overflow = 0.0;
            }
        } else {
            this.joker = true;
        }
        this.timeout -= time * overflow * this.rand;
        if (this.timeout > this.timeoutReset) {
            this.timeout = this.timeoutReset;
        }
        if (this.timeout < 0.0) {
            FMLLog.info((String)"%s destroying %s", (Object[])new Object[]{this.getClass().getName(), this.destructable.describe()});
            this.destructable.destructImpl();
        }
    }

    public ValueWatchdog set(IDestructable d) {
        this.destructable = d;
        return this;
    }

    abstract double getValue();

    public void disable() {
        this.max = 1.0E8;
        this.min = -this.max;
        this.timeoutReset = 1.0E7;
    }

    public void reset() {
        this.boot = true;
    }
}

