/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.simplenode.energyconverter;

import mods.eln.misc.DescriptorBase;
import mods.eln.simplenode.energyconverter.EnergyConverterElnToOtherNode;

public class EnergyConverterElnToOtherDescriptor
extends DescriptorBase {
    public ElnDescriptor eln;
    public Ic2Descriptor ic2;
    public OcDescriptor oc;

    public EnergyConverterElnToOtherDescriptor(String key, ElnDescriptor eln, Ic2Descriptor ic2, OcDescriptor oc) {
        super(key);
        this.eln = eln;
        this.ic2 = ic2;
        this.oc = oc;
    }

    void applyTo(EnergyConverterElnToOtherNode node) {
        node.inStdVoltage = this.eln.nominalU;
        node.inPowerMax = this.eln.maxP;
        node.energyBufferMax = this.eln.maxP * 2.0;
    }

    public static class OcDescriptor {
        public double outMax;

        public OcDescriptor(double outMax) {
            this.outMax = outMax;
        }
    }

    public static class Ic2Descriptor {
        public double outMax;
        public int tier;

        public Ic2Descriptor(double outMax, int tier) {
            this.outMax = outMax;
            this.tier = tier;
        }
    }

    public static class ElnDescriptor {
        public double nominalU;
        public double maxP;

        public ElnDescriptor(double nominalU, double maxP) {
            this.nominalU = nominalU;
            this.maxP = maxP;
        }
    }
}

