/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.simplenode.energyconverter;

import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.tile.IEnergySource;
import java.io.DataInputStream;
import java.io.IOException;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import mods.eln.Other;
import mods.eln.misc.Direction;
import mods.eln.node.simple.SimpleNode;
import mods.eln.node.simple.SimpleNodeEntity;
import mods.eln.simplenode.energyconverter.EnergyConverterElnToOtherFireWallIc2;
import mods.eln.simplenode.energyconverter.EnergyConverterElnToOtherFireWallOc;
import mods.eln.simplenode.energyconverter.EnergyConverterElnToOtherFireWallRf;
import mods.eln.simplenode.energyconverter.EnergyConverterElnToOtherGui;
import mods.eln.simplenode.energyconverter.EnergyConverterElnToOtherNode;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="IC2"), @Optional.Interface(iface="cofh.api.energy.IEnergyHandler", modid="Eln"), @Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="OpenComputers")})
public class EnergyConverterElnToOtherEntity
extends SimpleNodeEntity
implements IEnergySource,
Environment,
IEnergyHandler {
    float inPowerFactor;
    boolean hasChanges = false;
    public float inPowerMax;
    EnergyConverterElnToOtherFireWallOc oc;
    protected boolean addedToEnet;

    public EnergyConverterElnToOtherEntity() {
        if (Other.ocLoaded) {
            this.getOc().constructor();
        }
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        return super.onBlockActivated(entityPlayer, side, vx, vy, vz);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen newGuiDraw(Direction side, EntityPlayer player) {
        return new EnergyConverterElnToOtherGui(player, this);
    }

    @Override
    public void serverPublishUnserialize(DataInputStream stream) {
        super.serverPublishUnserialize(stream);
        try {
            this.inPowerFactor = stream.readFloat();
            this.inPowerMax = stream.readFloat();
            this.hasChanges = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getNodeUuid() {
        return EnergyConverterElnToOtherNode.getNodeUuidStatic();
    }

    @Optional.Method(modid="IC2")
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        SimpleNode n = this.getNode();
        if (n == null) {
            return false;
        }
        return n.getFront().back() == Direction.from(direction);
    }

    @Optional.Method(modid="IC2")
    public double getOfferedEnergy() {
        if (this.field_145850_b.field_72995_K) {
            return 0.0;
        }
        if (this.getNode() == null) {
            return 0.0;
        }
        EnergyConverterElnToOtherNode node = (EnergyConverterElnToOtherNode)this.getNode();
        double pMax = node.getOtherModOutMax(node.descriptor.ic2.outMax, Other.getElnToIc2ConversionRatio());
        return pMax;
    }

    @Optional.Method(modid="IC2")
    public void drawEnergy(double amount) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.getNode() == null) {
            return;
        }
        EnergyConverterElnToOtherNode node = (EnergyConverterElnToOtherNode)this.getNode();
        node.drawEnergy(amount, Other.getElnToIc2ConversionRatio());
    }

    @Optional.Method(modid="IC2")
    public int getSourceTier() {
        EnergyConverterElnToOtherNode node = (EnergyConverterElnToOtherNode)this.getNode();
        if (node == null) {
            return 0;
        }
        return node.descriptor.ic2.tier;
    }

    @Optional.Method(modid="OpenComputers")
    EnergyConverterElnToOtherFireWallOc getOc() {
        if (this.oc == null) {
            this.oc = new EnergyConverterElnToOtherFireWallOc(this);
        }
        return this.oc;
    }

    @Optional.Method(modid="OpenComputers")
    public Node node() {
        return this.getOc().node;
    }

    @Optional.Method(modid="OpenComputers")
    public void onConnect(Node node) {
    }

    @Optional.Method(modid="OpenComputers")
    public void onDisconnect(Node node) {
    }

    @Optional.Method(modid="OpenComputers")
    public void onMessage(Message message) {
    }

    @Override
    @Optional.Method(modid="Eln")
    public boolean canConnectEnergy(ForgeDirection from) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        if (this.getNode() == null) {
            return false;
        }
        SimpleNode n = this.getNode();
        return n.getFront().back() == Direction.from(from);
    }

    @Override
    @Optional.Method(modid="Eln")
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return 0;
    }

    @Override
    @Optional.Method(modid="Eln")
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (this.field_145850_b.field_72995_K) {
            return 0;
        }
        if (this.getNode() == null) {
            return 0;
        }
        EnergyConverterElnToOtherNode node = (EnergyConverterElnToOtherNode)this.getNode();
        int extract = Math.max(0, Math.min(maxExtract, (int)node.getOtherModEnergyBuffer(Other.getElnToTeConversionRatio())));
        if (!simulate) {
            node.drawEnergy(extract, Other.getElnToTeConversionRatio());
        }
        return extract;
    }

    @Override
    @Optional.Method(modid="Eln")
    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    @Override
    @Optional.Method(modid="Eln")
    public int getMaxEnergyStored(ForgeDirection from) {
        return 0;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (Other.ic2Loaded) {
            EnergyConverterElnToOtherFireWallIc2.updateEntity(this);
        }
        if (Other.ocLoaded) {
            this.getOc().updateEntity();
        }
        if (Other.teLoaded) {
            EnergyConverterElnToOtherFireWallRf.updateEntity(this);
        }
    }

    public void onLoaded() {
        if (Other.ic2Loaded) {
            EnergyConverterElnToOtherFireWallIc2.onLoaded(this);
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (Other.ic2Loaded) {
            EnergyConverterElnToOtherFireWallIc2.invalidate(this);
        }
        if (Other.ocLoaded) {
            this.getOc().invalidate();
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (Other.ic2Loaded) {
            EnergyConverterElnToOtherFireWallIc2.onChunkUnload(this);
        }
        if (Other.ocLoaded) {
            this.getOc().onChunkUnload();
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (Other.ocLoaded) {
            this.getOc().readFromNBT(nbt);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (Other.ocLoaded) {
            this.getOc().writeToNBT(nbt);
        }
    }
}

