/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.simplenode.energyconverter;

import mods.eln.gui.GuiHelper;
import mods.eln.gui.GuiScreenEln;
import mods.eln.gui.GuiVerticalTrackBar;
import mods.eln.gui.IGuiObject;
import mods.eln.i18n.I18N;
import mods.eln.simplenode.energyconverter.EnergyConverterElnToOtherEntity;
import net.minecraft.entity.player.EntityPlayer;

public class EnergyConverterElnToOtherGui
extends GuiScreenEln {
    EnergyConverterElnToOtherEntity render;
    GuiVerticalTrackBar voltage;

    public EnergyConverterElnToOtherGui(EntityPlayer player, EnergyConverterElnToOtherEntity render) {
        this.render = render;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.voltage = this.newGuiVerticalTrackBar(6, 8, 20, 50);
        this.voltage.setStepIdMax(100);
        this.voltage.setEnable(true);
        this.voltage.setRange(0.0f, 1.0f);
        this.syncVoltage();
    }

    public void syncVoltage() {
        this.voltage.setValue(this.render.inPowerFactor);
        this.render.hasChanges = false;
    }

    @Override
    public void guiObjectEvent(IGuiObject object) {
        super.guiObjectEvent(object);
        if (object == this.voltage) {
            this.render.sender.clientSendFloat((byte)1, this.voltage.getValue());
        }
    }

    @Override
    protected void preDraw(float f, int x, int y) {
        super.preDraw(f, x, y);
        if (this.render.hasChanges) {
            this.syncVoltage();
        }
        this.voltage.setComment(0, I18N.tr("Input power is limited to %1$W", (int)(this.voltage.getValue() * this.render.inPowerMax)));
    }

    @Override
    protected GuiHelper newHelper() {
        return new GuiHelper(this, 32, 66);
    }
}

