/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.simplenode.energyconverter;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.node.simple.SimpleNode;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtResistor;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.simplenode.energyconverter.EnergyConverterElnToOtherDescriptor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class EnergyConverterElnToOtherNode
extends SimpleNode {
    EnergyConverterElnToOtherDescriptor descriptor;
    NbtElectricalLoad load = new NbtElectricalLoad("load");
    NbtResistor powerInResistor = new NbtResistor("powerInResistor", this.load, null);
    ElectricalProcess electricalProcess = new ElectricalProcess();
    VoltageStateWatchDog watchdog = new VoltageStateWatchDog();
    public double energyBuffer = 0.0;
    public double energyBufferMax;
    public double inStdVoltage;
    public double inPowerMax;
    public double inPowerFactor = 0.5;
    public static final byte setInPowerFactor = 1;

    @Override
    protected void setDescriptorKey(String key) {
        super.setDescriptorKey(key);
        this.descriptor = (EnergyConverterElnToOtherDescriptor)this.getDescriptor();
    }

    @Override
    public int getSideConnectionMask(Direction directionA, LRDU lrduA) {
        if (directionA == this.getFront()) {
            return 1;
        }
        return 0;
    }

    @Override
    public ThermalLoad getThermalLoad(Direction directionA, LRDU lrduA) {
        return null;
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction directionB, LRDU lrduB) {
        return this.load;
    }

    @Override
    public void initialize() {
        this.electricalLoadList.add(this.load);
        this.electricalComponentList.add(this.powerInResistor);
        this.electricalProcessList.add(this.electricalProcess);
        this.slowProcessList.add(this.watchdog);
        Eln.applySmallRs(this.load);
        this.load.setAsPrivate();
        this.descriptor.applyTo(this);
        WorldExplosion exp = new WorldExplosion(this).machineExplosion();
        this.watchdog.set(this.load).setUNominal(this.inStdVoltage).set(exp);
        this.connect();
    }

    public double getOtherModEnergyBuffer(double conversionRatio) {
        return this.energyBuffer * conversionRatio;
    }

    public void drawEnergy(double otherModEnergy, double conversionRatio) {
        this.energyBuffer -= otherModEnergy / conversionRatio;
    }

    public double getOtherModOutMax(double otherOutMax, double conversionRatio) {
        return Math.min(this.getOtherModEnergyBuffer(conversionRatio), otherOutMax);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74780_a("energyBuffer", this.energyBuffer);
        nbt.func_74780_a("inPowerFactor", this.inPowerFactor);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.energyBuffer = nbt.func_74769_h("energyBuffer");
        this.inPowerFactor = nbt.func_74769_h("inPowerFactor");
    }

    @Override
    public boolean hasGui(Direction side) {
        return true;
    }

    @Override
    public void publishSerialize(DataOutputStream stream) {
        super.publishSerialize(stream);
        try {
            stream.writeFloat((float)this.inPowerFactor);
            stream.writeFloat((float)this.inPowerMax);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void networkUnserialize(DataInputStream stream, EntityPlayerMP player) {
        try {
            switch (stream.readByte()) {
                case 1: {
                    this.inPowerFactor = stream.readFloat();
                    this.needPublish();
                    break;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getNodeUuid() {
        return EnergyConverterElnToOtherNode.getNodeUuidStatic();
    }

    public static String getNodeUuidStatic() {
        return "ElnToOther";
    }

    class ElectricalProcess
    implements IProcess {
        double timeout = 0.0;

        ElectricalProcess() {
        }

        @Override
        public void process(double time) {
            EnergyConverterElnToOtherNode.this.energyBuffer += EnergyConverterElnToOtherNode.this.powerInResistor.getP() * time;
            this.timeout -= time;
            if (this.timeout < 0.0) {
                this.timeout = 0.05;
                double energyMiss = EnergyConverterElnToOtherNode.this.energyBufferMax - EnergyConverterElnToOtherNode.this.energyBuffer;
                if (energyMiss <= 0.0) {
                    EnergyConverterElnToOtherNode.this.powerInResistor.highImpedance();
                } else {
                    double factor = Math.min(1.0, energyMiss / EnergyConverterElnToOtherNode.this.energyBufferMax * 2.0);
                    if (factor < 0.005) {
                        factor = 0.0;
                    }
                    double inP = factor * EnergyConverterElnToOtherNode.this.inPowerMax * EnergyConverterElnToOtherNode.this.inPowerFactor;
                    EnergyConverterElnToOtherNode.this.powerInResistor.setR(EnergyConverterElnToOtherNode.this.inStdVoltage * EnergyConverterElnToOtherNode.this.inStdVoltage / inP);
                }
            }
        }
    }
}

