/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode;

import java.io.DataOutputStream;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import mods.eln.Eln;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.item.ElectricalFuseDescriptor;
import mods.eln.item.GenericItemUsingDamageDescriptorUpgrade;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sim.process.destruct.IDestructable;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;
import mods.eln.sim.process.heater.ResistorHeatThermalLoad;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020#H\u0016J\u0012\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\u0014\u0010+\u001a\u0004\u0018\u00010,2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\u0014\u0010-\u001a\u0004\u0018\u00010.2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\b\u0010/\u001a\u00020#H\u0016J\n\u00100\u001a\u0004\u0018\u00010%H\u0016J\u0012\u00101\u001a\u00020#2\b\u00102\u001a\u0004\u0018\u000103H\u0016J4\u00104\u001a\u00020\u00192\b\u00105\u001a\u0004\u0018\u0001062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u0002082\u0006\u0010:\u001a\u000208H\u0016J\u0012\u0010;\u001a\u00020#2\b\u0010<\u001a\u0004\u0018\u00010=H\u0016J\u0006\u0010>\u001a\u00020#J\n\u0010?\u001a\u0004\u0018\u00010%H\u0016J\u0012\u0010@\u001a\u00020#2\b\u0010<\u001a\u0004\u0018\u00010=H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lmods/eln/sixnode/ElectricalFuseHolderElement;", "Lmods/eln/node/six/SixNodeElement;", "Lmods/eln/sim/process/destruct/IDestructable;", "sixNode", "Lmods/eln/node/six/SixNode;", "side", "Lmods/eln/misc/Direction;", "descriptor", "Lmods/eln/node/six/SixNodeDescriptor;", "(Lmods/eln/node/six/SixNode;Lmods/eln/misc/Direction;Lmods/eln/node/six/SixNodeDescriptor;)V", "aLoad", "Lmods/eln/sim/nbt/NbtElectricalLoad;", "bLoad", "fuseMelting", "Lmods/eln/sim/process/heater/ResistorHeatThermalLoad;", "fuseResistor", "Lmods/eln/sim/mna/component/Resistor;", "value", "Lmods/eln/item/ElectricalFuseDescriptor;", "installedFuse", "getInstalledFuse", "()Lmods/eln/item/ElectricalFuseDescriptor;", "setInstalledFuse", "(Lmods/eln/item/ElectricalFuseDescriptor;)V", "nbtBoot", "", "getNbtBoot$ElectricalAge_release_main", "()Z", "setNbtBoot$ElectricalAge_release_main", "(Z)V", "thermalLoad", "Lmods/eln/sim/nbt/NbtThermalLoad;", "thermalWatchdog", "Lmods/eln/sim/process/destruct/ThermalLoadWatchDog;", "computeElectricalLoad", "", "describe", "", "destructImpl", "getConnectionMask", "", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "getThermalLoad", "Lmods/eln/sim/ThermalLoad;", "initialize", "multiMeterString", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "onBlockActivated", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "vx", "", "vy", "vz", "readFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "refreshSwitchResistor", "thermoMeterString", "writeToNBT", "ElectricalAge-release_main"})
public final class ElectricalFuseHolderElement
extends SixNodeElement
implements IDestructable {
    private final NbtElectricalLoad aLoad;
    private final NbtElectricalLoad bLoad;
    private final Resistor fuseResistor;
    private final NbtThermalLoad thermalLoad;
    private final ResistorHeatThermalLoad fuseMelting;
    private ThermalLoadWatchDog thermalWatchdog;
    @Nullable
    private ElectricalFuseDescriptor installedFuse;
    private boolean nbtBoot;

    @Nullable
    public final ElectricalFuseDescriptor getInstalledFuse() {
        return this.installedFuse;
    }

    public final void setInstalledFuse(@Nullable ElectricalFuseDescriptor value) {
        if (Intrinsics.areEqual(value, this.installedFuse)) {
            return;
        }
        this.installedFuse = value;
        this.thermalLoad.Tc = 0.0;
        this.thermalWatchdog.reset();
        this.refreshSwitchResistor();
        this.needPublish();
    }

    public final boolean getNbtBoot$ElectricalAge_release_main() {
        return this.nbtBoot;
    }

    public final void setNbtBoot$ElectricalAge_release_main(boolean bl) {
        this.nbtBoot = bl;
    }

    @Override
    public void readFromNBT(@Nullable NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        if (nbt != null) {
            ItemStack fuseStack;
            NBTTagCompound fuseCompound;
            this.front = LRDU.readFromNBT(nbt, "front");
            NBTBase nBTBase = nbt.func_74781_a("fuse");
            if (!(nBTBase instanceof NBTTagCompound)) {
                nBTBase = null;
            }
            if ((fuseCompound = (NBTTagCompound)nBTBase) != null && (fuseStack = ItemStack.func_77949_a((NBTTagCompound)fuseCompound)) != null) {
                GenericItemUsingDamageDescriptor genericItemUsingDamageDescriptor = GenericItemUsingDamageDescriptorUpgrade.getDescriptor(fuseStack);
                if (!(genericItemUsingDamageDescriptor instanceof ElectricalFuseDescriptor)) {
                    genericItemUsingDamageDescriptor = null;
                }
                this.setInstalledFuse((ElectricalFuseDescriptor)genericItemUsingDamageDescriptor);
            }
        }
        this.nbtBoot = true;
    }

    @Override
    public void writeToNBT(@Nullable NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        if (nbt != null) {
            this.front.writeToNBT(nbt, "front");
            if (this.installedFuse != null) {
                NBTTagCompound fuseCompaound = new NBTTagCompound();
                ElectricalFuseDescriptor electricalFuseDescriptor = this.installedFuse;
                if (electricalFuseDescriptor == null) {
                    Intrinsics.throwNpe();
                }
                electricalFuseDescriptor.newItemStack().func_77955_b(fuseCompaound);
                nbt.func_74782_a("fuse", (NBTBase)fuseCompaound);
            }
        }
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@Nullable LRDU lrdu) {
        LRDU lRDU = lrdu;
        return Intrinsics.areEqual((Object)lRDU, (Object)this.front) ? (ElectricalLoad)this.aLoad : (Intrinsics.areEqual((Object)lRDU, (Object)this.front.inverse()) ? (ElectricalLoad)this.bLoad : (ElectricalLoad)null);
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@Nullable LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(@Nullable LRDU lrdu) {
        LRDU lRDU = lrdu;
        return Intrinsics.areEqual((Object)lRDU, (Object)this.front) ? 5 : (Intrinsics.areEqual((Object)lRDU, (Object)this.front.inverse()) ? 5 : 0);
    }

    @Override
    @Nullable
    public String multiMeterString() {
        return Utils.plotAmpere("I:", Math.abs(this.aLoad.getCurrent()));
    }

    @Override
    @Nullable
    public String thermoMeterString() {
        return Utils.plotCelsius("T:", this.thermalLoad.getT());
    }

    @Override
    public void networkSerialize(@Nullable DataOutputStream stream) {
        super.networkSerialize(stream);
        if (stream != null) {
            try {
                ElectricalFuseDescriptor electricalFuseDescriptor = this.installedFuse;
                stream.writeFloat((float)(electricalFuseDescriptor != null ? electricalFuseDescriptor.getMaxCurrent() : 0.0));
            }
            catch (IOException e) {
                Throwable throwable = e;
                Throwable throwable2 = throwable;
                if (throwable2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
                }
                throwable2.printStackTrace();
            }
        }
    }

    public final void refreshSwitchResistor() {
        double maxCurrent;
        ElectricalFuseDescriptor electricalFuseDescriptor = this.installedFuse;
        double d = maxCurrent = electricalFuseDescriptor != null ? electricalFuseDescriptor.getMaxCurrent() : 0.0;
        if (maxCurrent <= 0.0) {
            this.fuseResistor.ultraImpedance();
        } else {
            double thermalMaximalPowerDissipated = maxCurrent * maxCurrent * 0.01;
            this.thermalLoad.C = thermalMaximalPowerDissipated * (Eln.cableHeatingTime / 2.0) / Eln.cableWarmLimit;
            this.thermalLoad.Rp = Eln.cableWarmLimit / thermalMaximalPowerDissipated;
            this.fuseResistor.setR(0.01);
        }
    }

    @Override
    public void initialize() {
        this.computeElectricalLoad();
    }

    public final void computeElectricalLoad() {
        Eln.instance.veryHighVoltageCableDescriptor.applyTo(this.aLoad);
        Eln.instance.veryHighVoltageCableDescriptor.applyTo(this.bLoad);
        this.refreshSwitchResistor();
    }

    @Override
    public boolean onBlockActivated(@Nullable EntityPlayer entityPlayer, @Nullable Direction side, float vx, float vy, float vz) {
        ElectricalFuseDescriptor fuseDescriptor;
        ElectricalFuseDescriptor takenOutFuse;
        block6: {
            if (Utils.isPlayerUsingWrench(entityPlayer)) {
                this.front = this.front.getNextClockwise();
                this.sixNode.reconnect();
                return true;
            }
            takenOutFuse = null;
            EntityPlayer entityPlayer2 = entityPlayer;
            Object itemStack = entityPlayer2 != null ? entityPlayer2.func_71045_bC() : null;
            GenericItemUsingDamageDescriptor genericItemUsingDamageDescriptor = GenericItemUsingDamageDescriptorUpgrade.getDescriptor(itemStack);
            if (!(genericItemUsingDamageDescriptor instanceof ElectricalFuseDescriptor)) {
                genericItemUsingDamageDescriptor = null;
            }
            fuseDescriptor = (ElectricalFuseDescriptor)genericItemUsingDamageDescriptor;
            if (itemStack != null) {
                if (fuseDescriptor != null && itemStack.field_77994_a > 0) {
                    int n = itemStack.field_77994_a;
                    itemStack.field_77994_a = n + -1;
                    takenOutFuse = this.installedFuse;
                    this.setInstalledFuse(fuseDescriptor);
                }
            } else {
                takenOutFuse = this.installedFuse;
                this.setInstalledFuse(null);
            }
            if (takenOutFuse == null) break block6;
            EntityPlayer entityPlayer3 = entityPlayer;
            if (entityPlayer3 != null) {
                entityPlayer3.func_70099_a(takenOutFuse.newItemStack(), 1.0f);
            }
        }
        return takenOutFuse != null || fuseDescriptor != null;
    }

    @Override
    public void destructImpl() {
        this.setInstalledFuse(ElectricalFuseDescriptor.Companion.getBlownFuse());
    }

    @Override
    @NotNull
    public String describe() {
        return "Fuse Holder";
    }

    public ElectricalFuseHolderElement(@NotNull SixNode sixNode, @NotNull Direction side, @NotNull SixNodeDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull(sixNode, "sixNode");
        Intrinsics.checkParameterIsNotNull((Object)side, "side");
        Intrinsics.checkParameterIsNotNull(descriptor, "descriptor");
        super(sixNode, side, descriptor);
        this.aLoad = new NbtElectricalLoad("aLoad");
        this.bLoad = new NbtElectricalLoad("bLoad");
        this.fuseResistor = new Resistor(this.aLoad, this.bLoad);
        this.thermalLoad = new NbtThermalLoad("thermalLoad");
        this.fuseMelting = new ResistorHeatThermalLoad(this.fuseResistor, this.thermalLoad);
        this.thermalWatchdog = new ThermalLoadWatchDog();
        this.electricalLoadList.add(this.aLoad);
        this.electricalLoadList.add(this.bLoad);
        this.electricalComponentList.add(this.fuseResistor);
        this.electricalComponentList.add(new Resistor(this.bLoad, null).pullDown());
        this.electricalComponentList.add(new Resistor(this.aLoad, null).pullDown());
        this.thermalLoadList.add(this.thermalLoad);
        this.thermalProcessList.add(this.fuseMelting);
        this.thermalLoad.setAsFast();
        this.slowProcessList.add(this.thermalWatchdog);
        this.thermalWatchdog.set(this.thermalLoad).setLimit(Eln.cableWarmLimit, -100.0).set(this);
    }
}

