/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mods.eln.i18n.I18N;
import mods.eln.sixnode.AnalogFunction;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\u001f\u001a\u00020\u00042\u000e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040!2\u0006\u0010\"\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010#J\u001c\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010\u0016H\u0016J\u001c\u0010)\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010\u0016H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR$\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0006\"\u0004\b\f\u0010\bR\u001a\u0010\r\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0006\"\u0004\b\u000f\u0010\bR\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lmods/eln/sixnode/PIDRegulator;", "Lmods/eln/sixnode/AnalogFunction;", "()V", "Kd", "", "getKd$ElectricalAge_release_main", "()D", "setKd$ElectricalAge_release_main", "(D)V", "value", "Ki", "getKi$ElectricalAge_release_main", "setKi$ElectricalAge_release_main", "Kp", "getKp$ElectricalAge_release_main", "setKp$ElectricalAge_release_main", "errorIntegral", "hasState", "", "getHasState", "()Z", "infos", "", "kotlin.jvm.PlatformType", "getInfos", "()Ljava/lang/String;", "inputCount", "", "getInputCount", "()I", "lastError", "process", "inputs", "", "deltaTime", "([Ljava/lang/Double;D)D", "readFromNBT", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "str", "writeToNBT", "ElectricalAge-release_main"})
public final class PIDRegulator
extends AnalogFunction {
    private final boolean hasState = true;
    private final int inputCount = 2;
    private final String infos = I18N.TR("Proportional\u2013integral\u2013derivative controller. A PID\ncontroller continuously calculates an error value as\nthe difference between a desired setpoint and a measured\nprocess variable and applies a correction based on\nproportional, integral, and derivative terms.");
    private double Kp = 1.0;
    private double Ki;
    private double Kd;
    private double lastError;
    private double errorIntegral;

    @Override
    public boolean getHasState() {
        return this.hasState;
    }

    @Override
    public int getInputCount() {
        return this.inputCount;
    }

    @Override
    public String getInfos() {
        return this.infos;
    }

    public final double getKp$ElectricalAge_release_main() {
        return this.Kp;
    }

    public final void setKp$ElectricalAge_release_main(double d) {
        this.Kp = d;
    }

    public final double getKi$ElectricalAge_release_main() {
        return this.Ki;
    }

    public final void setKi$ElectricalAge_release_main(double value) {
        this.Ki = value;
        this.errorIntegral = 0.0;
    }

    public final double getKd$ElectricalAge_release_main() {
        return this.Kd;
    }

    public final void setKd$ElectricalAge_release_main(double d) {
        this.Kd = d;
    }

    @Override
    public double process(@NotNull Double[] inputs, double deltaTime) {
        Intrinsics.checkParameterIsNotNull(inputs, "inputs");
        Double d = inputs[0];
        Double d2 = inputs[1];
        double error = (d != null ? d : 0.0) - (d2 != null ? d2 : 0.0);
        this.errorIntegral += error * deltaTime;
        double result = this.Kp * error + this.Ki * this.errorIntegral + this.Kd * (error - this.lastError) / deltaTime;
        this.lastError = error;
        return result;
    }

    @Override
    public void readFromNBT(@Nullable NBTTagCompound nbt, @Nullable String str) {
        NBTTagCompound nBTTagCompound = nbt;
        this.Kp = nBTTagCompound != null ? nBTTagCompound.func_74769_h("Kp") : 1.0;
        NBTTagCompound nBTTagCompound2 = nbt;
        this.setKi$ElectricalAge_release_main(nBTTagCompound2 != null ? nBTTagCompound2.func_74769_h("Ki") : 0.0);
        NBTTagCompound nBTTagCompound3 = nbt;
        this.Kd = nBTTagCompound3 != null ? nBTTagCompound3.func_74769_h("Kd") : 0.0;
        NBTTagCompound nBTTagCompound4 = nbt;
        this.errorIntegral = nBTTagCompound4 != null ? nBTTagCompound4.func_74769_h("errorIntegral") : 0.0;
    }

    @Override
    public void writeToNBT(@Nullable NBTTagCompound nbt, @Nullable String str) {
        block3: {
            NBTTagCompound nBTTagCompound = nbt;
            if (nBTTagCompound != null) {
                nBTTagCompound.func_74780_a("Kp", this.Kp);
            }
            NBTTagCompound nBTTagCompound2 = nbt;
            if (nBTTagCompound2 != null) {
                nBTTagCompound2.func_74780_a("Ki", this.Ki);
            }
            NBTTagCompound nBTTagCompound3 = nbt;
            if (nBTTagCompound3 != null) {
                nBTTagCompound3.func_74780_a("Kd", this.Kd);
            }
            NBTTagCompound nBTTagCompound4 = nbt;
            if (nBTTagCompound4 == null) break block3;
            nBTTagCompound4.func_74780_a("errorIntegral", this.errorIntegral);
        }
    }
}

