/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.sixnode.AnalogFunction;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0012\u001a\u00020\u00112\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001c\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\bH\u0016J\u001c\u0010\u001c\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lmods/eln/sixnode/VoltageControlledSawtoothOscillator;", "Lmods/eln/sixnode/AnalogFunction;", "()V", "hasState", "", "getHasState", "()Z", "infos", "", "kotlin.jvm.PlatformType", "getInfos", "()Ljava/lang/String;", "inputCount", "", "getInputCount", "()I", "out", "", "process", "inputs", "", "deltaTime", "([Ljava/lang/Double;D)D", "readFromNBT", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "str", "writeToNBT", "ElectricalAge-release_main"})
public class VoltageControlledSawtoothOscillator
extends AnalogFunction {
    private final boolean hasState = true;
    private final int inputCount = 1;
    private final String infos = I18N.TR("A voltage-controlled oscillator or VCO is\nan electronic oscillator whose oscillation\nfrequency is controlled by a voltage input.");
    private double out;

    @Override
    public boolean getHasState() {
        return this.hasState;
    }

    @Override
    public int getInputCount() {
        return this.inputCount;
    }

    @Override
    public String getInfos() {
        return this.infos;
    }

    @Override
    public double process(@NotNull Double[] inputs, double deltaTime) {
        Intrinsics.checkParameterIsNotNull(inputs, "inputs");
        Double d = inputs[0];
        this.out += Math.pow(50.0, (d != null ? d : 0.0) / (double)50) * (double)2 * deltaTime;
        if (this.out > Eln.SVU) {
            this.out = 0.0;
        }
        return this.out;
    }

    @Override
    public void readFromNBT(@Nullable NBTTagCompound nbt, @Nullable String str) {
        NBTTagCompound nBTTagCompound = nbt;
        this.out = nBTTagCompound != null ? nBTTagCompound.func_74769_h("out") : 0.0;
    }

    @Override
    public void writeToNBT(@Nullable NBTTagCompound nbt, @Nullable String str) {
        block0: {
            NBTTagCompound nBTTagCompound = nbt;
            if (nBTTagCompound == null) break block0;
            nBTTagCompound.func_74780_a("out", this.out);
        }
    }
}

