/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.batterycharger;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.item.electricalinterface.IItemEnergyBattery;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.ResistorPowerWatchdog;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sixnode.batterycharger.BatteryChargerContainer;
import mods.eln.sixnode.batterycharger.BatteryChargerDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class BatteryChargerElement
extends SixNodeElement {
    public BatteryChargerDescriptor descriptor;
    public NbtElectricalLoad powerLoad = new NbtElectricalLoad("powerLoad");
    public BatteryChargerSlowProcess slowProcess = new BatteryChargerSlowProcess();
    Resistor powerResistor = new Resistor(this.powerLoad, null);
    SixNodeElementInventory inventory = new SixNodeElementInventory(5, 64, this);
    VoltageStateWatchDog voltageWatchDog = new VoltageStateWatchDog();
    ResistorPowerWatchdog powerWatchDog = new ResistorPowerWatchdog();
    public String channel = "Default channel";
    boolean invChanged = false;
    boolean powerOn = false;
    public static final byte toogleCharge = 1;
    byte charged;
    byte presence;

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public Container newContainer(Direction side, EntityPlayer player) {
        return new BatteryChargerContainer(player, this.inventory);
    }

    public BatteryChargerElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.descriptor = (BatteryChargerDescriptor)descriptor;
        this.electricalLoadList.add(this.powerLoad);
        this.electricalComponentList.add(this.powerResistor);
        this.slowProcessList.add(this.slowProcess);
        WorldExplosion exp = new WorldExplosion(this).machineExplosion();
        this.slowProcessList.add(this.voltageWatchDog.set(this.powerLoad).setUNominal(this.descriptor.nominalVoltage).set(exp));
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu) {
        if (this.front == lrdu) {
            return this.powerLoad;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.front == lrdu) {
            return 1;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return Utils.plotUIP(this.powerLoad.getU(), this.powerLoad.getCurrent());
    }

    @Override
    public String thermoMeterString() {
        return null;
    }

    @Override
    public void initialize() {
        this.descriptor.applyTo(this.powerLoad);
    }

    @Override
    protected void inventoryChanged() {
        super.inventoryChanged();
        this.invChanged = true;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        if (Utils.isPlayerUsingWrench(entityPlayer)) {
            this.front = this.front.getNextClockwise();
            this.sixNode.reconnect();
            this.sixNode.setNeedPublish(true);
            return true;
        }
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74757_a("powerOn", this.powerOn);
        nbt.func_74780_a("energyCounter", this.slowProcess.energyCounter);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.powerOn = nbt.func_74767_n("powerOn");
        this.slowProcess.energyCounter = nbt.func_74769_h("energyCounter");
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            switch (stream.readByte()) {
                case 1: {
                    this.powerOn = !this.powerOn;
                    this.needPublish();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeBoolean(this.powerOn);
            stream.writeFloat((float)this.powerLoad.getU());
            Utils.serialiseItemStack(stream, this.inventory.func_70301_a(0));
            Utils.serialiseItemStack(stream, this.inventory.func_70301_a(1));
            Utils.serialiseItemStack(stream, this.inventory.func_70301_a(2));
            Utils.serialiseItemStack(stream, this.inventory.func_70301_a(3));
            stream.writeByte(this.charged);
            stream.writeByte(this.presence);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class BatteryChargerSlowProcess
    implements IProcess {
        double energyCounter = 0.0;
        double timeout = 0.0;

        BatteryChargerSlowProcess() {
        }

        @Override
        public void process(double time) {
            this.timeout -= time;
            if (this.timeout > 0.0) {
                return;
            }
            this.timeout = 1.0;
            time = 1.0;
            byte oldCharged = BatteryChargerElement.this.charged;
            BatteryChargerElement.this.charged = 0;
            BatteryChargerElement.this.presence = 0;
            if (!BatteryChargerElement.this.powerOn) {
                BatteryChargerElement.this.descriptor.setRp(BatteryChargerElement.this.powerResistor, false);
            } else {
                ItemStack booster = BatteryChargerElement.this.inventory.func_70301_a(4);
                double boost = 1.0;
                double eff = 1.0;
                if (booster != null) {
                    boost = Math.pow(1.25, booster.field_77994_a);
                    eff = Math.pow(0.9, booster.field_77994_a);
                }
                this.energyCounter += BatteryChargerElement.this.powerResistor.getP() * time * eff;
                for (int idx = 0; idx < 4; ++idx) {
                    ItemStack stack = BatteryChargerElement.this.inventory.func_70301_a(idx);
                    Object o = Utils.getItemObject(stack);
                    if (!(o instanceof IItemEnergyBattery)) continue;
                    IItemEnergyBattery b = (IItemEnergyBattery)o;
                    double e = Math.min(Math.min(this.energyCounter, b.getChargePower(stack) * time * boost), b.getEnergyMax(stack) - b.getEnergy(stack));
                    b.setEnergy(stack, b.getEnergy(stack) + e);
                    this.energyCounter -= e;
                }
                if (this.energyCounter < BatteryChargerElement.this.descriptor.nominalPower * time * 2.0 * boost) {
                    double power = Math.min(BatteryChargerElement.this.descriptor.nominalPower * boost, (BatteryChargerElement.this.descriptor.nominalPower * time * 2.0 * boost - this.energyCounter) / time);
                    BatteryChargerElement.this.powerResistor.setR(Math.max(BatteryChargerElement.this.powerLoad.getU() * BatteryChargerElement.this.powerLoad.getU() / power, BatteryChargerElement.this.descriptor.Rp / boost));
                } else {
                    BatteryChargerElement.this.descriptor.setRp(BatteryChargerElement.this.powerResistor, false);
                }
            }
            for (int idx = 0; idx < 4; ++idx) {
                ItemStack stack = BatteryChargerElement.this.inventory.func_70301_a(idx);
                Object o = Utils.getItemObject(stack);
                if (!(o instanceof IItemEnergyBattery)) continue;
                IItemEnergyBattery b = (IItemEnergyBattery)o;
                if (b.getEnergy(stack) == b.getEnergyMax(stack)) {
                    BatteryChargerElement.this.charged = (byte)(BatteryChargerElement.this.charged + (1 << idx));
                }
                BatteryChargerElement.this.presence = (byte)(BatteryChargerElement.this.presence + (1 << idx));
            }
            if (BatteryChargerElement.this.charged != oldCharged) {
                BatteryChargerElement.this.needPublish();
            }
            if (BatteryChargerElement.this.invChanged) {
                BatteryChargerElement.this.invChanged = false;
                BatteryChargerElement.this.needPublish();
            }
        }
    }
}

