/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.diode;

import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.sim.DiodeProcess;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.ResistorSwitch;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sim.process.heater.DiodeHeatThermalLoad;
import mods.eln.sixnode.diode.DiodeDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class DiodeElement
extends SixNodeElement {
    public DiodeDescriptor descriptor;
    public NbtElectricalLoad anodeLoad = new NbtElectricalLoad("anodeLoad");
    public NbtElectricalLoad catodeLoad = new NbtElectricalLoad("catodeLoad");
    public ResistorSwitch resistorSwitch = new ResistorSwitch("resistorSwitch", this.anodeLoad, this.catodeLoad);
    public NbtThermalLoad thermalLoad = new NbtThermalLoad("thermalLoad");
    public DiodeHeatThermalLoad heater = new DiodeHeatThermalLoad(this.resistorSwitch, this.thermalLoad);
    public ThermalLoadWatchDog thermalWatchdog = new ThermalLoadWatchDog();
    public DiodeProcess diodeProcess = new DiodeProcess(this.resistorSwitch);

    public DiodeElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.descriptor = (DiodeDescriptor)descriptor;
        this.thermalLoad.setAsSlow();
        this.electricalLoadList.add(this.anodeLoad);
        this.electricalLoadList.add(this.catodeLoad);
        this.thermalLoadList.add(this.thermalLoad);
        this.electricalComponentList.add(this.resistorSwitch);
        this.electricalProcessList.add(this.diodeProcess);
        this.slowProcessList.add(this.thermalWatchdog.set(this.thermalLoad).set(this.descriptor.thermal).set(new WorldExplosion(this).cableExplosion()));
        this.thermalSlowProcessList.add(this.heater);
    }

    public static boolean canBePlacedOnSide(Direction side, int type) {
        return true;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        byte value = nbt.func_74771_c("front");
        this.front = LRDU.fromInt(value >> 0 & 3);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74774_a("front", (byte)(this.front.toInt() << 0));
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu) {
        if (this.front == lrdu) {
            return this.anodeLoad;
        }
        if (this.front.inverse() == lrdu) {
            return this.catodeLoad;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(LRDU lrdu) {
        return this.thermalLoad;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.front == lrdu) {
            return this.descriptor.cable.getNodeMask();
        }
        if (this.front.inverse() == lrdu) {
            return this.descriptor.cable.getNodeMask();
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return Utils.plotVolt("U+:", this.anodeLoad.getU()) + Utils.plotVolt("U-:", this.catodeLoad.getU()) + Utils.plotAmpere("I:", this.anodeLoad.getCurrent());
    }

    @Override
    public String thermoMeterString() {
        return Utils.plotCelsius("T:", this.thermalLoad.Tc);
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeByte(this.front.toInt() << 4);
            stream.writeShort((short)(this.anodeLoad.getU() * 10.0));
            stream.writeShort((short)(this.catodeLoad.getU() * 10.0));
            stream.writeShort((short)(this.anodeLoad.getCurrent() * 100.0));
            stream.writeShort((short)(this.thermalLoad.Tc * 10.0));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize() {
        this.descriptor.applyTo(this.catodeLoad);
        this.descriptor.applyTo(this.anodeLoad);
        this.descriptor.applyTo(this.thermalLoad);
        this.descriptor.applyTo(this.resistorSwitch);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        ItemStack currentItemStack = entityPlayer.func_71045_bC();
        if (currentItemStack != null) {
            Item item = currentItemStack.func_77973_b();
        }
        if (Utils.isPlayerUsingWrench(entityPlayer)) {
            this.front = this.front.getNextClockwise();
            this.sixNode.reconnect();
            this.sixNode.setNeedPublish(true);
            return true;
        }
        return false;
    }
}

