/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.diode;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.sixnode.diode.DiodeDescriptor;

public class DiodeRender
extends SixNodeElementRender {
    private DiodeDescriptor descriptor;
    double voltageAnode = 0.0;
    double voltageCatode = 0.0;
    double current = 0.0;
    double temperature = 0.0;
    LRDU front;

    public DiodeRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (DiodeDescriptor)descriptor;
    }

    @Override
    public void draw() {
        this.front.glRotateOnX();
        this.descriptor.draw();
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            Byte b = stream.readByte();
            this.front = LRDU.fromInt(b >> 4 & 3);
            this.voltageAnode = (double)stream.readShort() / 10.0;
            this.voltageCatode = (double)stream.readShort() / 10.0;
            this.current = (double)stream.readShort() / 100.0;
            this.temperature = (double)stream.readShort() / 10.0;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

