/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalalarm;

import java.util.Collections;
import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.sixnode.electricalalarm.ElectricalAlarmElement;
import mods.eln.sixnode.electricalalarm.ElectricalAlarmRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ElectricalAlarmDescriptor
extends SixNodeDescriptor {
    public float[] pinDistance;
    int light;
    Obj3D obj;
    Obj3D.Obj3DPart main;
    Obj3D.Obj3DPart rot;
    Obj3D.Obj3DPart lightPart;
    ResourceLocation onTexture;
    ResourceLocation offTexture;
    String soundName;
    double soundTime;
    float soundLevel;
    public float rotSpeed = 0.0f;

    public ElectricalAlarmDescriptor(String name, Obj3D obj, int light, String soundName, double soundTime, float soundLevel) {
        super(name, ElectricalAlarmElement.class, ElectricalAlarmRender.class);
        this.obj = obj;
        this.soundName = soundName;
        this.soundTime = soundTime;
        this.soundLevel = soundLevel;
        this.light = light;
        if (obj != null) {
            this.main = obj.getPart("main");
            this.rot = obj.getPart("rot");
            this.lightPart = obj.getPart("light");
            this.onTexture = obj.getModelResourceLocation(obj.getString("onTexture"));
            this.offTexture = obj.getModelResourceLocation(obj.getString("offTexture"));
            if (this.rot != null) {
                this.rotSpeed = this.rot.getFloat("speed");
            }
            this.pinDistance = Utils.getSixNodePinDistance(this.main);
        }
        this.voltageLevelColor = VoltageLevelColor.SignalVoltage;
        this.changeDefaultIcon("electricalalarm");
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addUtilities(this.newItemStack());
    }

    void draw(boolean warm, float rotAlpha) {
        if (warm) {
            UtilsClient.bindTexture(this.onTexture);
        } else {
            UtilsClient.bindTexture(this.offTexture);
        }
        if (this.main != null) {
            this.main.drawNoBind();
        }
        if (this.rot != null) {
            GL11.glDisable((int)2884);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            if (warm) {
                UtilsClient.disableLight();
            } else {
                GL11.glDisable((int)2896);
            }
            this.rot.drawNoBind(rotAlpha, 1.0f, 0.0f, 0.0f);
            if (warm) {
                UtilsClient.enableLight();
            } else {
                GL11.glEnable((int)2896);
            }
            GL11.glEnable((int)2884);
        }
        if (this.lightPart != null) {
            UtilsClient.drawLightNoBind(this.lightPart);
        }
    }

    @Override
    public boolean use2DIcon() {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        }
        this.draw(true, 0.0f);
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        Collections.addAll(list, I18N.tr("Emits an acoustic alarm if\nthe input signal is high", new Object[0]).split("\n"));
        list.add(I18N.tr("", new Object[0]));
    }

    @Override
    public LRDU getFrontFromPlace(Direction side, EntityPlayer player) {
        return super.getFrontFromPlace(side, player).inverse();
    }
}

