/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalalarm;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalGateInput;
import mods.eln.sixnode.electricalalarm.ElectricalAlarmDescriptor;
import mods.eln.sixnode.electricalalarm.ElectricalAlarmSlowProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricalAlarmElement
extends SixNodeElement {
    ElectricalAlarmDescriptor descriptor;
    public NbtElectricalGateInput inputGate = new NbtElectricalGateInput("inputGate");
    public ElectricalAlarmSlowProcess slowProcess = new ElectricalAlarmSlowProcess(this);
    boolean warm = false;
    boolean mute = false;
    public static final byte clientSoundToggle = 1;

    public ElectricalAlarmElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.electricalLoadList.add(this.inputGate);
        this.slowProcessList.add(this.slowProcess);
        this.descriptor = (ElectricalAlarmDescriptor)descriptor;
    }

    public static boolean canBePlacedOnSide(Direction side, int type) {
        return true;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        byte value = nbt.func_74771_c("front");
        this.front = LRDU.fromInt(value >> 0 & 3);
        this.mute = nbt.func_74767_n("mute");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74774_a("front", (byte)(this.front.toInt() << 0));
        nbt.func_74757_a("mute", this.mute);
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu) {
        if (this.front == lrdu) {
            return this.inputGate;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.front == lrdu) {
            return 4;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return Utils.plotVolt("U:", this.inputGate.getU()) + Utils.plotAmpere("I:", this.inputGate.getCurrent());
    }

    @Override
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeByte((this.front.toInt() << 4) + (this.warm ? 1 : 0));
            stream.writeBoolean(this.mute);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setWarm(boolean value) {
        if (this.warm != value) {
            this.warm = value;
            this.sixNode.recalculateLightValue();
            this.needPublish();
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public int getLightValue() {
        return this.warm ? this.descriptor.light : 0;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        ItemStack currentItemStack = entityPlayer.func_71045_bC();
        if (Utils.isPlayerUsingWrench(entityPlayer)) {
            this.front = this.front.getNextClockwise();
            this.sixNode.reconnect();
            this.sixNode.setNeedPublish(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            switch (stream.readByte()) {
                case 1: {
                    this.mute = !this.mute;
                    this.needPublish();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

