/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalalarm;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.RcInterpolator;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.sixnode.electricalalarm.ElectricalAlarmDescriptor;
import mods.eln.sixnode.electricalalarm.ElectricalAlarmGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

public class ElectricalAlarmRender
extends SixNodeElementRender {
    ElectricalAlarmDescriptor descriptor;
    LRDU front;
    RcInterpolator interpol = new RcInterpolator(0.4f);
    float rotAlpha = 0.0f;
    boolean warm = false;
    boolean mute = false;

    public ElectricalAlarmRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (ElectricalAlarmDescriptor)descriptor;
    }

    @Override
    public void draw() {
        super.draw();
        if (this.side.isY()) {
            this.front.right().glRotateOnX();
            this.drawSignalPin(LRDU.Down, this.descriptor.pinDistance);
        } else {
            this.drawSignalPin(this.front, this.descriptor.pinDistance);
        }
        this.descriptor.draw(this.warm, this.rotAlpha);
    }

    @Override
    public void refresh(float deltaT) {
        this.interpol.setTarget(this.warm ? this.descriptor.rotSpeed : 0.0f);
        this.interpol.step(deltaT);
        this.rotAlpha += this.interpol.get() * deltaT;
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            Byte b = stream.readByte();
            this.front = LRDU.fromInt(b >> 4 & 3);
            this.warm = (b & 1) != 0;
            this.mute = stream.readBoolean();
            Utils.println("WARM : " + this.warm);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public CableRenderDescriptor getCableRender(LRDU lrdu) {
        return Eln.instance.signalCableDescriptor.render;
    }

    @Override
    public GuiScreen newGuiDraw(Direction side, EntityPlayer player) {
        return new ElectricalAlarmGui(player, this);
    }
}

