/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalbreaker;

import mods.eln.misc.INBTTReady;
import mods.eln.sim.IProcess;
import mods.eln.sixnode.electricalbreaker.ElectricalBreakerElement;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricalBreakerCutProcess
implements IProcess,
INBTTReady {
    ElectricalBreakerElement breaker;
    double T = 0.0;

    public ElectricalBreakerCutProcess(ElectricalBreakerElement breaker) {
        this.breaker = breaker;
    }

    @Override
    public void process(double time) {
        double U = this.breaker.aLoad.getU();
        double I = this.breaker.aLoad.getCurrent();
        double Tmax = 0.0;
        ElectricalCableDescriptor cable = this.breaker.cableDescriptor;
        if (cable == null) {
            this.T = 0.0;
        } else {
            Math.min(I, cable.electricalNominalPower / cable.electricalMaximalVoltage * 10.0);
            double P = I * I * cable.electricalRs * 2.0 - this.T / cable.thermalRp * 0.9;
            if (I > 1.0) {
                int idx = 0;
                ++idx;
            }
            this.T += P / cable.thermalC * time;
            Tmax = cable.thermalWarmLimit * 0.8;
        }
        if (U >= (double)this.breaker.voltageMax || U < (double)this.breaker.voltageMin || this.T > Tmax) {
            this.breaker.setSwitchState(false);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String str) {
        this.T = nbt.func_74760_g(str + "T");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String str) {
        nbt.func_74776_a(str + "T", (float)this.T);
    }
}

