/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalbreaker;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sixnode.electricalbreaker.ElectricalBreakerContainer;
import mods.eln.sixnode.electricalbreaker.ElectricalBreakerCutProcess;
import mods.eln.sixnode.electricalbreaker.ElectricalBreakerDescriptor;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.sound.SoundCommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricalBreakerElement
extends SixNodeElement {
    public ElectricalBreakerDescriptor descriptor;
    public NbtElectricalLoad aLoad = new NbtElectricalLoad("aLoad");
    public NbtElectricalLoad bLoad = new NbtElectricalLoad("bLoad");
    public Resistor switchResistor = new Resistor(this.aLoad, this.bLoad);
    public ElectricalBreakerCutProcess cutProcess = new ElectricalBreakerCutProcess(this);
    SixNodeElementInventory inventory = new SixNodeElementInventory(1, 64, this);
    public float voltageMax = 50.0f;
    public float voltageMin = 0.0f;
    boolean switchState = false;
    double currantMax = 0.0;
    boolean nbtBoot = false;
    public ElectricalCableDescriptor cableDescriptor = null;
    public static final byte setVoltageMaxId = 1;
    public static final byte setVoltageMinId = 2;
    public static final byte toogleSwitchId = 3;

    public ElectricalBreakerElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.electricalLoadList.add(this.aLoad);
        this.electricalLoadList.add(this.bLoad);
        this.electricalComponentList.add(this.switchResistor);
        this.electricalComponentList.add(new Resistor(this.bLoad, null).pullDown());
        this.electricalComponentList.add(new Resistor(this.aLoad, null).pullDown());
        this.electricalProcessList.add(this.cutProcess);
        this.descriptor = (ElectricalBreakerDescriptor)descriptor;
    }

    @Override
    public SixNodeElementInventory getInventory() {
        return this.inventory;
    }

    public static boolean canBePlacedOnSide(Direction side, int type) {
        return true;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        byte value = nbt.func_74771_c("front");
        this.front = LRDU.fromInt(value >> 0 & 3);
        this.switchState = nbt.func_74767_n("switchState");
        this.voltageMax = nbt.func_74760_g("voltageMax");
        this.voltageMin = nbt.func_74760_g("voltageMin");
        this.nbtBoot = true;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74774_a("front", (byte)(this.front.toInt() << 0));
        nbt.func_74757_a("switchState", this.switchState);
        nbt.func_74776_a("voltageMax", this.voltageMax);
        nbt.func_74776_a("voltageMin", this.voltageMin);
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu) {
        if (this.front == lrdu) {
            return this.aLoad;
        }
        if (this.front.inverse() == lrdu) {
            return this.bLoad;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.inventory.func_70301_a(0) == null) {
            return 0;
        }
        if (this.front == lrdu) {
            return 5;
        }
        if (this.front.inverse() == lrdu) {
            return 5;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return Utils.plotVolt("Ua:", this.aLoad.getU()) + Utils.plotVolt("Ub:", this.bLoad.getU()) + Utils.plotVolt("I:", this.aLoad.getCurrent());
    }

    @Override
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeBoolean(this.switchState);
            stream.writeFloat(this.voltageMax);
            stream.writeFloat(this.voltageMin);
            Utils.serialiseItemStack(stream, this.inventory.func_70301_a(0));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setSwitchState(boolean state) {
        if (state == this.switchState) {
            return;
        }
        this.play(new SoundCommand("random.click").mulVolume(0.3f, 0.6f).smallRange());
        this.switchState = state;
        this.refreshSwitchResistor();
        this.needPublish();
    }

    public void refreshSwitchResistor() {
        ItemStack cable = this.inventory.func_70301_a(0);
        ElectricalCableDescriptor cableDescriptor = (ElectricalCableDescriptor)Eln.sixNodeItem.getDescriptor(cable);
        if (cableDescriptor == null || !this.switchState) {
            this.switchResistor.ultraImpedance();
        } else {
            cableDescriptor.applyTo(this.switchResistor);
        }
    }

    public boolean getSwitchState() {
        return this.switchState;
    }

    @Override
    public void initialize() {
        this.computeElectricalLoad();
        this.setSwitchState(this.switchState);
    }

    @Override
    protected void inventoryChanged() {
        this.computeElectricalLoad();
        this.reconnect();
    }

    public void computeElectricalLoad() {
        ItemStack cable = this.inventory.func_70301_a(0);
        if (!this.nbtBoot) {
            this.setSwitchState(false);
        }
        this.nbtBoot = false;
        this.cableDescriptor = (ElectricalCableDescriptor)Eln.sixNodeItem.getDescriptor(cable);
        if (this.cableDescriptor == null) {
            this.aLoad.highImpedance();
            this.bLoad.highImpedance();
        } else {
            this.cableDescriptor.applyTo(this.aLoad);
            this.cableDescriptor.applyTo(this.bLoad);
            this.currantMax = this.cableDescriptor.electricalMaximalCurrent;
        }
        this.refreshSwitchResistor();
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        ItemStack currentItemStack = entityPlayer.func_71045_bC();
        if (Utils.isPlayerUsingWrench(entityPlayer)) {
            this.front = this.front.getNextClockwise();
            this.sixNode.reconnect();
            return true;
        }
        if (Eln.multiMeterElement.checkSameItemStack(entityPlayer.func_71045_bC())) {
            return false;
        }
        if (Eln.thermoMeterElement.checkSameItemStack(entityPlayer.func_71045_bC())) {
            return false;
        }
        if (Eln.allMeterElement.checkSameItemStack(entityPlayer.func_71045_bC())) {
            return false;
        }
        return false;
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            switch (stream.readByte()) {
                case 1: {
                    this.voltageMax = stream.readFloat();
                    this.needPublish();
                    break;
                }
                case 2: {
                    this.voltageMin = stream.readFloat();
                    this.needPublish();
                    break;
                }
                case 3: {
                    this.setSwitchState(!this.getSwitchState());
                    this.needPublish();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public Container newContainer(Direction side, EntityPlayer player) {
        return new ElectricalBreakerContainer(player, this.inventory);
    }
}

